/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.options;

import java.time.Duration;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.description.Description;
import org.apache.paimon.options.description.TextElement;
import org.apache.paimon.table.TableType;

public class CatalogOptions {
    public static final ConfigOption<String> WAREHOUSE = ConfigOptions.key("warehouse").stringType().noDefaultValue().withDescription("The warehouse root path of catalog.");
    public static final ConfigOption<String> METASTORE = ConfigOptions.key("metastore").stringType().defaultValue("filesystem").withDescription("Metastore of paimon catalog, supports filesystem and hive.");
    public static final ConfigOption<String> URI = ConfigOptions.key("uri").stringType().noDefaultValue().withDescription("Uri of metastore server.");
    public static final ConfigOption<TableType> TABLE_TYPE = ConfigOptions.key("table.type").enumType(TableType.class).defaultValue(TableType.MANAGED).withDescription("Type of table.");
    public static final ConfigOption<Boolean> LOCK_ENABLED = ConfigOptions.key("lock.enabled").booleanType().defaultValue(false).withDescription("Enable Catalog Lock.");
    public static final ConfigOption<Duration> LOCK_CHECK_MAX_SLEEP = ConfigOptions.key("lock-check-max-sleep").durationType().defaultValue(Duration.ofSeconds(8L)).withDescription("The maximum sleep time when retrying to check the lock.");
    public static final ConfigOption<Duration> LOCK_ACQUIRE_TIMEOUT = ConfigOptions.key("lock-acquire-timeout").durationType().defaultValue(Duration.ofMinutes(8L)).withDescription("The maximum time to wait for acquiring the lock.");
    public static final ConfigOption<Boolean> FS_ALLOW_HADOOP_FALLBACK = ConfigOptions.key("fs.allow-hadoop-fallback").booleanType().defaultValue(true).withDescription("Allow to fallback to hadoop File IO when no file io found for the scheme.");
    public static final ConfigOption<String> LINEAGE_META = ConfigOptions.key("lineage-meta").stringType().noDefaultValue().withDescription(Description.builder().text("The lineage meta to store table and data lineage information.").linebreak().linebreak().text("Possible values:").linebreak().list(TextElement.text("\"jdbc\": Use standard jdbc to store table and data lineage information.")).list(TextElement.text("\"custom\": You can implement LineageMetaFactory and LineageMeta to store lineage information in customized storage.")).build());
}

