/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.io.airlift.compress.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DoNotPool;
import org.apache.paimon.shade.io.airlift.compress.gzip.HadoopJdkGzipInputStream;
import org.apache.paimon.shade.io.airlift.compress.gzip.HadoopJdkGzipOutputStream;

public class JdkGzipCodec
implements CompressionCodec {
    public CompressionOutputStream createOutputStream(OutputStream outputStream) throws IOException {
        return new HadoopJdkGzipOutputStream(outputStream, 8192);
    }

    public CompressionOutputStream createOutputStream(OutputStream outputStream, Compressor compressor) throws IOException {
        if (!(compressor instanceof HadoopGzipCompressor)) {
            throw new IllegalArgumentException("Compressor is not the Gzip decompressor");
        }
        return new HadoopJdkGzipOutputStream(outputStream, 8192);
    }

    public Class<? extends Compressor> getCompressorType() {
        return HadoopGzipCompressor.class;
    }

    public Compressor createCompressor() {
        return new HadoopGzipCompressor();
    }

    public CompressionInputStream createInputStream(InputStream inputStream) throws IOException {
        return new HadoopJdkGzipInputStream(inputStream, 8192);
    }

    public CompressionInputStream createInputStream(InputStream inputStream, Decompressor decompressor) throws IOException {
        if (!(decompressor instanceof HadoopGzipDecompressor)) {
            throw new IllegalArgumentException("Decompressor is not the Gzip decompressor");
        }
        return new HadoopJdkGzipInputStream(inputStream, 8192);
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return HadoopGzipDecompressor.class;
    }

    public Decompressor createDecompressor() {
        return new HadoopGzipDecompressor();
    }

    public String getDefaultExtension() {
        return ".gz";
    }

    @DoNotPool
    private static class HadoopGzipDecompressor
    implements Decompressor {
        private HadoopGzipDecompressor() {
        }

        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        public boolean needsInput() {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        public boolean needsDictionary() {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        public boolean finished() {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        public int decompress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        public void reset() {
        }

        public int getRemaining() {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        public void end() {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }
    }

    @DoNotPool
    private static class HadoopGzipCompressor
    implements Compressor {
        private HadoopGzipCompressor() {
        }

        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        public boolean needsInput() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        public long getBytesRead() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        public long getBytesWritten() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        public void finish() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        public boolean finished() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        public int compress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        public void reset() {
        }

        public void end() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        public void reinit(Configuration conf) {
        }
    }
}

