/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc.impl.writer;

import java.io.IOException;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.paimon.shade.org.apache.orc.OrcProto;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.shade.org.apache.orc.impl.BitFieldWriter;
import org.apache.paimon.shade.org.apache.orc.impl.OutStream;
import org.apache.paimon.shade.org.apache.orc.impl.PositionRecorder;
import org.apache.paimon.shade.org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.paimon.shade.org.apache.orc.impl.writer.WriterContext;

public class BooleanTreeWriter
extends TreeWriterBase {
    private final BitFieldWriter writer;

    public BooleanTreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
        OutStream out = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
        this.writer = new BitFieldWriter(out, 1);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block3: {
            LongColumnVector vec;
            block2: {
                super.writeBatch(vector, offset, length);
                vec = (LongColumnVector)vector;
                if (!vector.isRepeating) break block2;
                if (!vector.noNulls && vector.isNull[0]) break block3;
                int value = vec.vector[0] == 0L ? 0 : 1;
                this.indexStatistics.updateBoolean(value != 0, length);
                for (int i = 0; i < length; ++i) {
                    this.writer.write(value);
                }
                break block3;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                int value = vec.vector[i + offset] == 0L ? 0 : 1;
                this.writer.write(value);
                this.indexStatistics.updateBoolean(value != 0, 1);
            }
        }
    }

    @Override
    public void writeStripe(OrcProto.StripeFooter.Builder builder, OrcProto.StripeStatistics.Builder stats, int requiredIndexEntries) throws IOException {
        super.writeStripe(builder, stats, requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.writer.getPosition(recorder);
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.writer.estimateMemory();
    }

    @Override
    public long getRawDataSize() {
        long num = this.fileStatistics.getNumberOfValues();
        return num * (long)JavaDataModel.get().primitive1();
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.writer.flush();
    }
}

