/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.column;

import java.util.Objects;
import java.util.OptionalLong;
import org.apache.paimon.shade.org.apache.parquet.Preconditions;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesUtils;
import org.apache.paimon.shade.org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import org.apache.paimon.shade.org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnProperty;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnWriteStore;
import org.apache.paimon.shade.org.apache.parquet.column.impl.ColumnWriteStoreV1;
import org.apache.paimon.shade.org.apache.parquet.column.impl.ColumnWriteStoreV2;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageWriteStore;
import org.apache.paimon.shade.org.apache.parquet.column.values.ValuesWriter;
import org.apache.paimon.shade.org.apache.parquet.column.values.bitpacking.DevNullValuesWriter;
import org.apache.paimon.shade.org.apache.parquet.column.values.bloomfilter.BloomFilterWriteStore;
import org.apache.paimon.shade.org.apache.parquet.column.values.factory.DefaultValuesWriterFactory;
import org.apache.paimon.shade.org.apache.parquet.column.values.factory.ValuesWriterFactory;
import org.apache.paimon.shade.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.paimon.shade.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import org.apache.paimon.shade.org.apache.parquet.schema.MessageType;

public class ParquetProperties {
    public static final int DEFAULT_PAGE_SIZE = 0x100000;
    public static final int DEFAULT_DICTIONARY_PAGE_SIZE = 0x100000;
    public static final boolean DEFAULT_IS_DICTIONARY_ENABLED = true;
    public static final boolean DEFAULT_IS_BYTE_STREAM_SPLIT_ENABLED = false;
    public static final WriterVersion DEFAULT_WRITER_VERSION = WriterVersion.PARQUET_1_0;
    public static final boolean DEFAULT_ESTIMATE_ROW_COUNT_FOR_PAGE_SIZE_CHECK = true;
    public static final int DEFAULT_MINIMUM_RECORD_COUNT_FOR_CHECK = 100;
    public static final int DEFAULT_MAXIMUM_RECORD_COUNT_FOR_CHECK = 10000;
    public static final int DEFAULT_COLUMN_INDEX_TRUNCATE_LENGTH = 64;
    public static final int DEFAULT_STATISTICS_TRUNCATE_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_PAGE_ROW_COUNT_LIMIT = 20000;
    public static final int DEFAULT_MAX_BLOOM_FILTER_BYTES = 0x100000;
    public static final boolean DEFAULT_BLOOM_FILTER_ENABLED = false;
    public static final boolean DEFAULT_PAGE_WRITE_CHECKSUM_ENABLED = true;
    public static final ValuesWriterFactory DEFAULT_VALUES_WRITER_FACTORY = new DefaultValuesWriterFactory();
    private static final int MIN_SLAB_SIZE = 64;
    private final int initialSlabSize;
    private final int pageSizeThreshold;
    private final int dictionaryPageSizeThreshold;
    private final WriterVersion writerVersion;
    private final ColumnProperty<Boolean> dictionaryEnabled;
    private final int minRowCountForPageSizeCheck;
    private final int maxRowCountForPageSizeCheck;
    private final boolean estimateNextSizeCheck;
    private final ByteBufferAllocator allocator;
    private final ValuesWriterFactory valuesWriterFactory;
    private final int columnIndexTruncateLength;
    private final int statisticsTruncateLength;
    private final ColumnProperty<Long> bloomFilterNDVs;
    private final int maxBloomFilterBytes;
    private final ColumnProperty<Boolean> bloomFilterEnabled;
    private final int pageRowCountLimit;
    private final boolean pageWriteChecksumEnabled;
    private final boolean enableByteStreamSplit;

    private ParquetProperties(Builder builder) {
        this.pageSizeThreshold = builder.pageSize;
        this.initialSlabSize = CapacityByteArrayOutputStream.initialSlabSizeHeuristic(64, this.pageSizeThreshold, 10);
        this.dictionaryPageSizeThreshold = builder.dictPageSize;
        this.writerVersion = builder.writerVersion;
        this.dictionaryEnabled = builder.enableDict.build();
        this.minRowCountForPageSizeCheck = builder.minRowCountForPageSizeCheck;
        this.maxRowCountForPageSizeCheck = builder.maxRowCountForPageSizeCheck;
        this.estimateNextSizeCheck = builder.estimateNextSizeCheck;
        this.allocator = builder.allocator;
        this.valuesWriterFactory = builder.valuesWriterFactory;
        this.columnIndexTruncateLength = builder.columnIndexTruncateLength;
        this.statisticsTruncateLength = builder.statisticsTruncateLength;
        this.bloomFilterNDVs = builder.bloomFilterNDVs.build();
        this.bloomFilterEnabled = builder.bloomFilterEnabled.build();
        this.maxBloomFilterBytes = builder.maxBloomFilterBytes;
        this.pageRowCountLimit = builder.pageRowCountLimit;
        this.pageWriteChecksumEnabled = builder.pageWriteChecksumEnabled;
        this.enableByteStreamSplit = builder.enableByteStreamSplit;
    }

    public ValuesWriter newRepetitionLevelWriter(ColumnDescriptor path) {
        return this.newColumnDescriptorValuesWriter(path.getMaxRepetitionLevel());
    }

    public ValuesWriter newDefinitionLevelWriter(ColumnDescriptor path) {
        return this.newColumnDescriptorValuesWriter(path.getMaxDefinitionLevel());
    }

    private ValuesWriter newColumnDescriptorValuesWriter(int maxLevel) {
        if (maxLevel == 0) {
            return new DevNullValuesWriter();
        }
        return new RunLengthBitPackingHybridValuesWriter(BytesUtils.getWidthFromMaxInt(maxLevel), 64, this.pageSizeThreshold, this.allocator);
    }

    public RunLengthBitPackingHybridEncoder newRepetitionLevelEncoder(ColumnDescriptor path) {
        return this.newLevelEncoder(path.getMaxRepetitionLevel());
    }

    public RunLengthBitPackingHybridEncoder newDefinitionLevelEncoder(ColumnDescriptor path) {
        return this.newLevelEncoder(path.getMaxDefinitionLevel());
    }

    private RunLengthBitPackingHybridEncoder newLevelEncoder(int maxLevel) {
        return new RunLengthBitPackingHybridEncoder(BytesUtils.getWidthFromMaxInt(maxLevel), 64, this.pageSizeThreshold, this.allocator);
    }

    public ValuesWriter newValuesWriter(ColumnDescriptor path) {
        return this.valuesWriterFactory.newValuesWriter(path);
    }

    public int getPageSizeThreshold() {
        return this.pageSizeThreshold;
    }

    public int getInitialSlabSize() {
        return this.initialSlabSize;
    }

    public int getDictionaryPageSizeThreshold() {
        return this.dictionaryPageSizeThreshold;
    }

    public WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    @Deprecated
    public boolean isEnableDictionary() {
        return this.dictionaryEnabled.getDefaultValue();
    }

    public boolean isDictionaryEnabled(ColumnDescriptor column) {
        return this.dictionaryEnabled.getValue(column);
    }

    public boolean isByteStreamSplitEnabled() {
        return this.enableByteStreamSplit;
    }

    public ByteBufferAllocator getAllocator() {
        return this.allocator;
    }

    public ColumnWriteStore newColumnWriteStore(MessageType schema, PageWriteStore pageStore) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return new ColumnWriteStoreV1(schema, pageStore, this);
            }
            case PARQUET_2_0: {
                return new ColumnWriteStoreV2(schema, pageStore, this);
            }
        }
        throw new IllegalArgumentException("unknown version " + (Object)((Object)this.writerVersion));
    }

    public ColumnWriteStore newColumnWriteStore(MessageType schema, PageWriteStore pageStore, BloomFilterWriteStore bloomFilterWriteStore) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return new ColumnWriteStoreV1(schema, pageStore, bloomFilterWriteStore, this);
            }
            case PARQUET_2_0: {
                return new ColumnWriteStoreV2(schema, pageStore, bloomFilterWriteStore, this);
            }
        }
        throw new IllegalArgumentException("unknown version " + (Object)((Object)this.writerVersion));
    }

    public int getMinRowCountForPageSizeCheck() {
        return this.minRowCountForPageSizeCheck;
    }

    public int getMaxRowCountForPageSizeCheck() {
        return this.maxRowCountForPageSizeCheck;
    }

    public ValuesWriterFactory getValuesWriterFactory() {
        return this.valuesWriterFactory;
    }

    public int getColumnIndexTruncateLength() {
        return this.columnIndexTruncateLength;
    }

    public int getStatisticsTruncateLength() {
        return this.statisticsTruncateLength;
    }

    public boolean estimateNextSizeCheck() {
        return this.estimateNextSizeCheck;
    }

    public int getPageRowCountLimit() {
        return this.pageRowCountLimit;
    }

    public boolean getPageWriteChecksumEnabled() {
        return this.pageWriteChecksumEnabled;
    }

    public OptionalLong getBloomFilterNDV(ColumnDescriptor column) {
        Long ndv = this.bloomFilterNDVs.getValue(column);
        return ndv == null ? OptionalLong.empty() : OptionalLong.of(ndv);
    }

    public boolean isBloomFilterEnabled(ColumnDescriptor column) {
        return this.bloomFilterEnabled.getValue(column);
    }

    public int getMaxBloomFilterBytes() {
        return this.maxBloomFilterBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder copy(ParquetProperties toCopy) {
        return new Builder(toCopy);
    }

    public String toString() {
        return "Parquet page size to " + this.getPageSizeThreshold() + '\n' + "Parquet dictionary page size to " + this.getDictionaryPageSizeThreshold() + '\n' + "Dictionary is " + this.dictionaryEnabled + '\n' + "Writer version is: " + (Object)((Object)this.getWriterVersion()) + '\n' + "Page size checking is: " + (this.estimateNextSizeCheck() ? "estimated" : "constant") + '\n' + "Min row count for page size check is: " + this.getMinRowCountForPageSizeCheck() + '\n' + "Max row count for page size check is: " + this.getMaxRowCountForPageSizeCheck() + '\n' + "Truncate length for column indexes is: " + this.getColumnIndexTruncateLength() + '\n' + "Truncate length for statistics min/max  is: " + this.getStatisticsTruncateLength() + '\n' + "Bloom filter enabled: " + this.bloomFilterEnabled + '\n' + "Max Bloom filter size for a column is " + this.getMaxBloomFilterBytes() + '\n' + "Bloom filter expected number of distinct values are: " + this.bloomFilterNDVs + '\n' + "Page row count limit to " + this.getPageRowCountLimit() + '\n' + "Writing page checksums is: " + (this.getPageWriteChecksumEnabled() ? "on" : "off");
    }

    public static class Builder {
        private int pageSize = 0x100000;
        private int dictPageSize = 0x100000;
        private final ColumnProperty.Builder<Boolean> enableDict;
        private WriterVersion writerVersion = DEFAULT_WRITER_VERSION;
        private int minRowCountForPageSizeCheck = 100;
        private int maxRowCountForPageSizeCheck = 10000;
        private boolean estimateNextSizeCheck = true;
        private ByteBufferAllocator allocator = new HeapByteBufferAllocator();
        private ValuesWriterFactory valuesWriterFactory = DEFAULT_VALUES_WRITER_FACTORY;
        private int columnIndexTruncateLength = 64;
        private int statisticsTruncateLength = Integer.MAX_VALUE;
        private final ColumnProperty.Builder<Long> bloomFilterNDVs;
        private int maxBloomFilterBytes = 0x100000;
        private final ColumnProperty.Builder<Boolean> bloomFilterEnabled;
        private int pageRowCountLimit = 20000;
        private boolean pageWriteChecksumEnabled = true;
        private boolean enableByteStreamSplit = false;

        private Builder() {
            this.enableDict = ColumnProperty.builder().withDefaultValue(true);
            this.bloomFilterEnabled = ColumnProperty.builder().withDefaultValue(false);
            this.bloomFilterNDVs = ColumnProperty.builder().withDefaultValue(null);
        }

        private Builder(ParquetProperties toCopy) {
            this.pageSize = toCopy.pageSizeThreshold;
            this.enableDict = ColumnProperty.builder(toCopy.dictionaryEnabled);
            this.dictPageSize = toCopy.dictionaryPageSizeThreshold;
            this.writerVersion = toCopy.writerVersion;
            this.minRowCountForPageSizeCheck = toCopy.minRowCountForPageSizeCheck;
            this.maxRowCountForPageSizeCheck = toCopy.maxRowCountForPageSizeCheck;
            this.estimateNextSizeCheck = toCopy.estimateNextSizeCheck;
            this.valuesWriterFactory = toCopy.valuesWriterFactory;
            this.allocator = toCopy.allocator;
            this.pageRowCountLimit = toCopy.pageRowCountLimit;
            this.pageWriteChecksumEnabled = toCopy.pageWriteChecksumEnabled;
            this.bloomFilterNDVs = ColumnProperty.builder(toCopy.bloomFilterNDVs);
            this.bloomFilterEnabled = ColumnProperty.builder(toCopy.bloomFilterEnabled);
            this.maxBloomFilterBytes = toCopy.maxBloomFilterBytes;
            this.enableByteStreamSplit = toCopy.enableByteStreamSplit;
        }

        public Builder withPageSize(int pageSize) {
            Preconditions.checkArgument(pageSize > 0, "Invalid page size (negative): %s", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder withDictionaryEncoding(boolean enableDictionary) {
            this.enableDict.withDefaultValue(enableDictionary);
            return this;
        }

        public Builder withDictionaryEncoding(String columnPath, boolean enableDictionary) {
            this.enableDict.withValue(columnPath, (Boolean)enableDictionary);
            return this;
        }

        public Builder withByteStreamSplitEncoding(boolean enableByteStreamSplit) {
            this.enableByteStreamSplit = enableByteStreamSplit;
            return this;
        }

        public Builder withDictionaryPageSize(int dictionaryPageSize) {
            Preconditions.checkArgument(dictionaryPageSize > 0, "Invalid dictionary page size (negative): %s", dictionaryPageSize);
            this.dictPageSize = dictionaryPageSize;
            return this;
        }

        public Builder withWriterVersion(WriterVersion version) {
            this.writerVersion = version;
            return this;
        }

        public Builder withMinRowCountForPageSizeCheck(int min) {
            Preconditions.checkArgument(min > 0, "Invalid row count for page size check (negative): %s", min);
            this.minRowCountForPageSizeCheck = min;
            return this;
        }

        public Builder withMaxRowCountForPageSizeCheck(int max) {
            Preconditions.checkArgument(max > 0, "Invalid row count for page size check (negative): %s", max);
            this.maxRowCountForPageSizeCheck = max;
            return this;
        }

        public Builder estimateRowCountForPageSizeCheck(boolean estimateNextSizeCheck) {
            this.estimateNextSizeCheck = estimateNextSizeCheck;
            return this;
        }

        public Builder withAllocator(ByteBufferAllocator allocator) {
            this.allocator = Objects.requireNonNull(allocator, "ByteBufferAllocator cannot be null");
            return this;
        }

        public Builder withValuesWriterFactory(ValuesWriterFactory factory) {
            this.valuesWriterFactory = Objects.requireNonNull(factory, "ValuesWriterFactory cannot be null");
            return this;
        }

        public Builder withColumnIndexTruncateLength(int length) {
            Preconditions.checkArgument(length > 0, "Invalid column index min/max truncate length (negative or zero) : %s", length);
            this.columnIndexTruncateLength = length;
            return this;
        }

        public Builder withStatisticsTruncateLength(int length) {
            Preconditions.checkArgument(length > 0, "Invalid statistics min/max truncate length (negative or zero) : %s", length);
            this.statisticsTruncateLength = length;
            return this;
        }

        public Builder withMaxBloomFilterBytes(int maxBloomFilterBytes) {
            this.maxBloomFilterBytes = maxBloomFilterBytes;
            return this;
        }

        public Builder withBloomFilterNDV(String columnPath, long ndv) {
            Preconditions.checkArgument(ndv > 0L, "Invalid NDV for column \"%s\": %d", columnPath, ndv);
            this.bloomFilterNDVs.withValue(columnPath, (Long)ndv);
            this.bloomFilterEnabled.withValue(columnPath, (Boolean)true);
            return this;
        }

        public Builder withBloomFilterEnabled(boolean enabled) {
            this.bloomFilterEnabled.withDefaultValue(enabled);
            return this;
        }

        public Builder withBloomFilterEnabled(String columnPath, boolean enabled) {
            this.bloomFilterEnabled.withValue(columnPath, (Boolean)enabled);
            return this;
        }

        public Builder withPageRowCountLimit(int rowCount) {
            Preconditions.checkArgument(rowCount > 0, "Invalid row count limit for pages: " + rowCount);
            this.pageRowCountLimit = rowCount;
            return this;
        }

        public Builder withPageWriteChecksumEnabled(boolean val) {
            this.pageWriteChecksumEnabled = val;
            return this;
        }

        public ParquetProperties build() {
            ParquetProperties properties = new ParquetProperties(this);
            this.valuesWriterFactory.initialize(properties);
            return properties;
        }
    }

    public static enum WriterVersion {
        PARQUET_1_0("v1"),
        PARQUET_2_0("v2");

        private final String shortName;

        private WriterVersion(String shortname) {
            this.shortName = shortname;
        }

        public static WriterVersion fromString(String name) {
            for (WriterVersion v : WriterVersion.values()) {
                if (!v.shortName.equals(name)) continue;
                return v;
            }
            return WriterVersion.valueOf(name);
        }
    }
}

