/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.mergetree.compact.DeduplicateMergeFunction;
import org.apache.paimon.mergetree.compact.FirstRowMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.PartialUpdateMergeFunction;
import org.apache.paimon.mergetree.compact.aggregate.AggregateMergeFunction;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;

public class ChangelogWithKeyTableUtils {
    public static RowType addKeyNamePrefix(RowType type) {
        return new RowType(ChangelogWithKeyTableUtils.addKeyNamePrefix(type.getFields()));
    }

    public static List<DataField> addKeyNamePrefix(List<DataField> keyFields) {
        return keyFields.stream().map(f -> new DataField(f.id(), "_KEY_" + f.name(), f.type(), f.description())).collect(Collectors.toList());
    }

    public static MergeFunctionFactory<KeyValue> createMergeFunctionFactory(TableSchema tableSchema) {
        RowType rowType = tableSchema.logicalRowType();
        Options conf = Options.fromMap(tableSchema.options());
        CoreOptions options = new CoreOptions(conf);
        CoreOptions.MergeEngine mergeEngine = options.mergeEngine();
        ChangelogWithKeyKeyValueFieldsExtractor extractor = ChangelogWithKeyKeyValueFieldsExtractor.EXTRACTOR;
        switch (mergeEngine) {
            case DEDUPLICATE: {
                return DeduplicateMergeFunction.factory();
            }
            case PARTIAL_UPDATE: {
                return PartialUpdateMergeFunction.factory(conf, rowType);
            }
            case AGGREGATE: {
                return AggregateMergeFunction.factory(conf, tableSchema.fieldNames(), rowType.getFieldTypes(), tableSchema.primaryKeys());
            }
            case FIRST_ROW: {
                return FirstRowMergeFunction.factory(new RowType(extractor.keyFields(tableSchema)), rowType);
            }
        }
        throw new UnsupportedOperationException("Unsupported merge engine: " + mergeEngine);
    }

    static class ChangelogWithKeyKeyValueFieldsExtractor
    implements KeyValueFieldsExtractor {
        private static final long serialVersionUID = 1L;
        static final ChangelogWithKeyKeyValueFieldsExtractor EXTRACTOR = new ChangelogWithKeyKeyValueFieldsExtractor();

        private ChangelogWithKeyKeyValueFieldsExtractor() {
        }

        @Override
        public List<DataField> keyFields(TableSchema schema) {
            return ChangelogWithKeyTableUtils.addKeyNamePrefix(schema.trimmedPrimaryKeysFields());
        }

        @Override
        public List<DataField> valueFields(TableSchema schema) {
            return schema.fields();
        }
    }
}

