/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.operation.ScanKind;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;

public class ContinuousFromSnapshotFullStartingScanner
implements StartingScanner {
    private final long snapshotId;

    public ContinuousFromSnapshotFullStartingScanner(long snapshotId) {
        this.snapshotId = snapshotId;
    }

    @Override
    public StartingScanner.Result scan(SnapshotManager snapshotManager, SnapshotReader snapshotReader) {
        Long earliestSnapshotId = snapshotManager.earliestSnapshotId();
        if (earliestSnapshotId == null) {
            return new StartingScanner.NoSnapshot();
        }
        long ceiledSnapshotId = Math.max(this.snapshotId, earliestSnapshotId);
        return StartingScanner.fromPlan(snapshotReader.withKind(ScanKind.ALL).withSnapshot(ceiledSnapshotId).read());
    }
}

