/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.SnapshotManager;

public interface StartingScanner {
    public Result scan(SnapshotManager var1, SnapshotReader var2);

    public static ScannedResult fromPlan(SnapshotReader.Plan plan) {
        return new ScannedResult(plan.snapshotId(), plan.watermark(), plan.splits());
    }

    public static class NextSnapshot
    implements Result {
        private final long nextSnapshotId;

        public NextSnapshot(long nextSnapshotId) {
            this.nextSnapshotId = nextSnapshotId;
        }

        public long nextSnapshotId() {
            return this.nextSnapshotId;
        }
    }

    public static class ScannedResult
    implements Result {
        private final long currentSnapshotId;
        @Nullable
        private final Long currentWatermark;
        private final List<DataSplit> splits;

        public ScannedResult(long currentSnapshotId, @Nullable Long currentWatermark, List<DataSplit> splits) {
            this.currentSnapshotId = currentSnapshotId;
            this.currentWatermark = currentWatermark;
            this.splits = splits;
        }

        public long currentSnapshotId() {
            return this.currentSnapshotId;
        }

        @Nullable
        public Long currentWatermark() {
            return this.currentWatermark;
        }

        public List<DataSplit> splits() {
            return this.splits;
        }
    }

    public static class NoSnapshot
    implements Result {
    }

    public static interface Result {
    }
}

