/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.types.RowKind;
import org.apache.paimon.flink.action.TableActionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAction
extends TableActionBase {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteAction.class);
    private final String filter;

    public DeleteAction(String warehouse, String databaseName, String tableName, String filter, Map<String, String> catalogConfig) {
        super(warehouse, databaseName, tableName, catalogConfig);
        this.changeIgnoreMergeEngine();
        this.filter = filter;
    }

    @Override
    public void run() throws Exception {
        LOG.debug("Run delete action with filter '{}'.", (Object)this.filter);
        Table queriedTable = this.batchTEnv.sqlQuery(String.format("SELECT * FROM %s WHERE %s", this.identifier.getEscapedFullName(), this.filter));
        List converters = queriedTable.getResolvedSchema().getColumnDataTypes().stream().map(DataStructureConverters::getConverter).collect(Collectors.toList());
        SingleOutputStreamOperator dataStream = this.batchTEnv.toChangelogStream(queriedTable).map((MapFunction & Serializable)row -> {
            int arity = row.getArity();
            GenericRowData rowData = new GenericRowData(RowKind.DELETE, arity);
            for (int i = 0; i < arity; ++i) {
                rowData.setField(i, ((DataStructureConverter)converters.get(i)).toInternalOrNull(row.getField(i)));
            }
            return rowData;
        });
        this.batchSink((DataStream<RowData>)dataStream).await();
    }
}

