/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.format.debezium;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.mysql.MySqlTypeUtils;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.StringUtils;

public class DebeziumSchemaUtils {
    public static String transformRawValue(@Nullable String rawValue, String debeziumType, @Nullable String className, TypeMapping typeMapping, JsonNode origin) {
        if (rawValue == null) {
            return null;
        }
        String transformed = rawValue;
        if ("io.debezium.data.Bits".equals(className)) {
            byte[] littleEndian = Base64.getDecoder().decode(rawValue);
            byte[] bigEndian = new byte[littleEndian.length];
            for (int i = 0; i < littleEndian.length; ++i) {
                bigEndian[i] = littleEndian[littleEndian.length - 1 - i];
            }
            transformed = typeMapping.containsMode(TypeMapping.TypeMappingMode.TO_STRING) ? StringUtils.bytesToBinaryString(bigEndian) : Base64.getEncoder().encodeToString(bigEndian);
        } else if ("bytes".equals(debeziumType) && className == null) {
            transformed = new String(Base64.getDecoder().decode(rawValue));
        } else {
            if ("bytes".equals(debeziumType) && "org.apache.flink.kafka.shaded.org.apache.kafka.connect.data.Decimal".equals(className)) {
                try {
                    new BigDecimal(rawValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid big decimal value " + rawValue + ". Make sure that in the `customConverterConfigs` of the JsonDebeziumDeserializationSchema you created, set '" + "decimal.format" + "' to 'numeric'", e);
                }
            }
            if ("io.debezium.time.Date".equals(className)) {
                transformed = DateTimeUtils.toLocalDate(Integer.parseInt(rawValue)).toString();
            } else if ("io.debezium.time.Timestamp".equals(className)) {
                LocalDateTime localDateTime = DateTimeUtils.toLocalDateTime(Long.parseLong(rawValue), ZoneOffset.UTC);
                transformed = DateTimeUtils.formatLocalDateTime(localDateTime, 3);
            } else if ("io.debezium.time.MicroTimestamp".equals(className)) {
                long microseconds = Long.parseLong(rawValue);
                long microsecondsPerSecond = 1000000L;
                long nanosecondsPerMicros = 1000L;
                long seconds = microseconds / microsecondsPerSecond;
                long nanoAdjustment = microseconds % microsecondsPerSecond * nanosecondsPerMicros;
                LocalDateTime localDateTime = Instant.ofEpochSecond(seconds, nanoAdjustment).atZone(ZoneOffset.UTC).toLocalDateTime();
                transformed = DateTimeUtils.formatLocalDateTime(localDateTime, 6);
            } else if ("io.debezium.time.ZonedTimestamp".equals(className)) {
                LocalDateTime localDateTime = Instant.parse(rawValue).atZone(ZoneOffset.UTC).toLocalDateTime();
                transformed = DateTimeUtils.formatLocalDateTime(localDateTime, 6);
            } else if ("io.debezium.time.MicroTime".equals(className)) {
                long microseconds = Long.parseLong(rawValue);
                long microsecondsPerSecond = 1000000L;
                long nanosecondsPerMicros = 1000L;
                long seconds = microseconds / microsecondsPerSecond;
                long nanoAdjustment = microseconds % microsecondsPerSecond * nanosecondsPerMicros;
                transformed = Instant.ofEpochSecond(seconds, nanoAdjustment).atZone(ZoneOffset.UTC).toLocalTime().toString();
            } else if ("io.debezium.data.geometry.Point".equals(className) || "io.debezium.data.geometry.Geometry".equals(className)) {
                try {
                    byte[] wkb = origin.get("wkb").binaryValue();
                    transformed = MySqlTypeUtils.convertWkbArray(wkb);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Failed to convert %s to geometry JSON.", rawValue), e);
                }
            }
        }
        return transformed;
    }

    public static DataType toDataType(String debeziumType, @Nullable String className, Map<String, String> parameters) {
        if (className != null) {
            switch (className) {
                case "io.debezium.data.Bits": {
                    int length = Integer.parseInt(parameters.get("length"));
                    return DataTypes.BINARY((length + 7) / 8);
                }
                case "org.apache.flink.kafka.shaded.org.apache.kafka.connect.data.Decimal": {
                    String precision = parameters.get("connect.decimal.precision");
                    if (precision == null) {
                        return DataTypes.DECIMAL(20, 0);
                    }
                    int p = Integer.parseInt(precision);
                    if (p > 38) {
                        return DataTypes.STRING();
                    }
                    int scale = Integer.parseInt(parameters.get("scale"));
                    return DataTypes.DECIMAL(p, scale);
                }
                case "io.debezium.time.Date": {
                    return DataTypes.DATE();
                }
                case "io.debezium.time.Timestamp": {
                    return DataTypes.TIMESTAMP(3);
                }
                case "io.debezium.time.MicroTimestamp": 
                case "io.debezium.time.ZonedTimestamp": {
                    return DataTypes.TIMESTAMP(6);
                }
                case "io.debezium.time.MicroTime": {
                    return DataTypes.TIME();
                }
            }
        }
        return DebeziumSchemaUtils.fromDebeziumType(debeziumType);
    }

    private static DataType fromDebeziumType(String dbzType) {
        switch (dbzType) {
            case "int8": {
                return DataTypes.TINYINT();
            }
            case "int16": {
                return DataTypes.SMALLINT();
            }
            case "int32": {
                return DataTypes.INT();
            }
            case "int64": {
                return DataTypes.BIGINT();
            }
            case "float32": 
            case "float64": {
                return DataTypes.FLOAT();
            }
            case "double": {
                return DataTypes.DOUBLE();
            }
            case "boolean": {
                return DataTypes.BOOLEAN();
            }
            case "bytes": {
                return DataTypes.BYTES();
            }
        }
        return DataTypes.STRING();
    }
}

