/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.watermark;

import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.paimon.flink.action.cdc.watermark.CdcTimestampExtractorFactory;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;

public class CdcWatermarkStrategy
implements WatermarkStrategy<String> {
    private final CdcTimestampExtractorFactory.CdcTimestampExtractor timestampExtractor;
    private static final long serialVersionUID = 1L;
    private long currentMaxTimestamp;

    public CdcWatermarkStrategy(CdcTimestampExtractorFactory.CdcTimestampExtractor extractor) {
        this.timestampExtractor = extractor;
    }

    public WatermarkGenerator<String> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
        return new WatermarkGenerator<String>(){

            public void onEvent(String record, long timestamp, WatermarkOutput output) {
                long tMs;
                try {
                    tMs = CdcWatermarkStrategy.this.timestampExtractor.extractTimestamp(record);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                CdcWatermarkStrategy.this.currentMaxTimestamp = Math.max(CdcWatermarkStrategy.this.currentMaxTimestamp, tMs);
                output.emitWatermark(new Watermark(CdcWatermarkStrategy.this.currentMaxTimestamp - 1L));
            }

            public void onPeriodicEmit(WatermarkOutput output) {
                long timeMillis = System.currentTimeMillis();
                CdcWatermarkStrategy.this.currentMaxTimestamp = Math.max(timeMillis, CdcWatermarkStrategy.this.currentMaxTimestamp);
                output.emitWatermark(new Watermark(CdcWatermarkStrategy.this.currentMaxTimestamp - 1L));
            }
        };
    }
}

