/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.flink.lookup.FullCacheLookupTable;
import org.apache.paimon.flink.lookup.PrimaryKeyLookupTable;
import org.apache.paimon.lookup.RocksDBSetState;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.KeyProjectedRow;
import org.apache.paimon.utils.TypeUtils;

public class SecondaryIndexLookupTable
extends PrimaryKeyLookupTable {
    private final RocksDBSetState<InternalRow, InternalRow> indexState;
    private final KeyProjectedRow secKeyRow;

    public SecondaryIndexLookupTable(FullCacheLookupTable.Context context, long lruCacheSize) throws IOException {
        super(context, lruCacheSize / 2L, context.table.primaryKeys());
        List<String> fieldNames = this.projectedType.getFieldNames();
        int[] secKeyMapping = context.joinKey.stream().mapToInt(fieldNames::indexOf).toArray();
        this.secKeyRow = new KeyProjectedRow(secKeyMapping);
        this.indexState = this.stateFactory.setState("sec-index", InternalSerializers.create(TypeUtils.project(this.projectedType, secKeyMapping)), InternalSerializers.create(TypeUtils.project(this.projectedType, this.primaryKeyMapping)), lruCacheSize / 2L);
    }

    @Override
    public List<InternalRow> innerGet(InternalRow key) throws IOException {
        List<InternalRow> pks = this.indexState.get(key);
        ArrayList<InternalRow> values = new ArrayList<InternalRow>(pks.size());
        for (InternalRow pk : pks) {
            InternalRow row = (InternalRow)this.tableState.get(pk);
            if (row == null) continue;
            values.add(row);
        }
        return values;
    }

    @Override
    public void refresh(Iterator<InternalRow> incremental, boolean orderByLastField) throws IOException {
        while (incremental.hasNext()) {
            InternalRow row = incremental.next();
            this.primaryKeyRow.replaceRow(row);
            boolean previousFetched = false;
            InternalRow previous = null;
            if (orderByLastField) {
                previous = (InternalRow)this.tableState.get(this.primaryKeyRow);
                previousFetched = true;
                int orderIndex = this.projectedType.getFieldCount() - 1;
                if (previous != null && previous.getLong(orderIndex) > row.getLong(orderIndex)) continue;
            }
            if (row.getRowKind() == RowKind.INSERT || row.getRowKind() == RowKind.UPDATE_AFTER) {
                if (!previousFetched) {
                    previous = (InternalRow)this.tableState.get(this.primaryKeyRow);
                }
                if (previous != null) {
                    this.indexState.retract(this.secKeyRow.replaceRow(previous), this.primaryKeyRow);
                }
                if (this.recordFilter().test(row)) {
                    this.tableState.put(this.primaryKeyRow, row);
                    this.indexState.add(this.secKeyRow.replaceRow(row), this.primaryKeyRow);
                    continue;
                }
                this.tableState.delete(this.primaryKeyRow);
                continue;
            }
            this.tableState.delete(this.primaryKeyRow);
            this.indexState.retract(this.secKeyRow.replaceRow(row), this.primaryKeyRow);
        }
    }

    @Override
    public void bulkLoadWritePlus(byte[] key, byte[] value) throws IOException {
        InternalRow row = (InternalRow)this.tableState.deserializeValue(value);
        this.indexState.add(this.secKeyRow.replaceRow(row), this.primaryKeyRow.replaceRow(row));
    }
}

