/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecordKeyAndBucketExtractor;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.ChannelComputer;
import org.apache.paimon.utils.MathUtils;

public class CdcAssignerChannelComputer
implements ChannelComputer<CdcRecord> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private Integer numAssigners;
    private transient int numChannels;
    private transient CdcRecordKeyAndBucketExtractor extractor;

    public CdcAssignerChannelComputer(TableSchema schema, Integer numAssigners) {
        this.schema = schema;
        this.numAssigners = numAssigners;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.numAssigners = MathUtils.min(this.numAssigners, numChannels);
        this.extractor = new CdcRecordKeyAndBucketExtractor(this.schema);
    }

    @Override
    public int channel(CdcRecord record) {
        this.extractor.setRecord(record);
        int partitionHash = this.extractor.partition().hashCode();
        int keyHash = this.extractor.trimmedPrimaryKey().hashCode();
        return BucketAssigner.computeAssigner(partitionHash, keyHash, this.numChannels, this.numAssigners);
    }

    public String toString() {
        return "shuffle by key hash";
    }
}

