/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecordKeyAndBucketExtractor;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.ChannelComputer;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;

public class CdcRecordChannelComputer
implements ChannelComputer<CdcRecord> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private transient int numChannels;
    private transient KeyAndBucketExtractor<CdcRecord> extractor;

    public CdcRecordChannelComputer(TableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.extractor = new CdcRecordKeyAndBucketExtractor(this.schema);
    }

    @Override
    public int channel(CdcRecord record) {
        this.extractor.setRecord(record);
        return this.channel(this.extractor.partition(), this.extractor.bucket());
    }

    public int channel(BinaryRow partition, int bucket) {
        return ChannelComputer.select(partition, bucket, this.numChannels);
    }

    public String toString() {
        return "shuffle by bucket";
    }
}

