/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io.cache;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.RemovalCause;
import org.apache.paimon.shade.guava30.com.google.common.util.concurrent.MoreExecutors;

public class CacheManager {
    public static final int REFRESH_COUNT = 10;
    private final Cache<CacheKey, CacheValue> cache;
    private int fileReadCount;

    public CacheManager(MemorySize maxMemorySize) {
        this.cache = Caffeine.newBuilder().weigher(this::weigh).maximumWeight(maxMemorySize.getBytes()).removalListener(this::onRemoval).executor(MoreExecutors.directExecutor()).build();
        this.fileReadCount = 0;
    }

    @VisibleForTesting
    public Cache<CacheKey, CacheValue> cache() {
        return this.cache;
    }

    public MemorySegment getPage(RandomAccessFile file, long readOffset, int readLength, BiConsumer<Long, Integer> cleanCallback) {
        CacheKey key = new CacheKey(file, readOffset, readLength);
        CacheValue value = this.cache.getIfPresent(key);
        while (value == null || value.isClosed) {
            try {
                value = new CacheValue(key.read(), cleanCallback);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.cache.put(key, value);
        }
        return value.segment;
    }

    public void invalidPage(RandomAccessFile file, long readOffset, int readLength) {
        this.cache.invalidate(new CacheKey(file, readOffset, readLength));
    }

    private int weigh(CacheKey cacheKey, CacheValue cacheValue) {
        return cacheValue.segment.size();
    }

    private void onRemoval(CacheKey key, CacheValue value, RemovalCause cause) {
        value.isClosed = true;
        value.cleanCallback.accept(key.offset, key.length);
    }

    public int fileReadCount() {
        return this.fileReadCount;
    }

    private static class CacheValue {
        private final MemorySegment segment;
        private final BiConsumer<Long, Integer> cleanCallback;
        private boolean isClosed = false;

        private CacheValue(MemorySegment segment, BiConsumer<Long, Integer> cleanCallback) {
            this.segment = segment;
            this.cleanCallback = cleanCallback;
        }
    }

    private class CacheKey {
        private final RandomAccessFile file;
        private final long offset;
        private final int length;

        private CacheKey(RandomAccessFile file, long offset, int length) {
            this.file = file;
            this.offset = offset;
            this.length = length;
        }

        private MemorySegment read() throws IOException {
            byte[] bytes = new byte[this.length];
            this.file.seek(this.offset);
            this.file.readFully(bytes);
            CacheManager.this.fileReadCount++;
            return MemorySegment.wrap(bytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.file, cacheKey.file) && this.offset == cacheKey.offset && this.length == cacheKey.length;
        }

        public int hashCode() {
            return Objects.hash(this.file, this.offset, this.length);
        }
    }
}

