/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import java.util.List;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.io.DataFileMeta;

public class CompactionStats {
    private final long duration;
    private final long compactedDataFilesBefore;
    private final long compactedDataFilesAfter;
    private final long compactedChangelogs;
    private final long rewriteInputFileSize;
    private final long rewriteOutputFileSize;
    private final long rewriteChangelogFileSize;

    public CompactionStats(long compactionDuration, List<DataFileMeta> compactBefore, List<DataFileMeta> compactAfter, List<DataFileMeta> compactChangelog) {
        this.duration = compactionDuration;
        this.compactedDataFilesBefore = compactBefore.size();
        this.compactedDataFilesAfter = compactAfter.size();
        this.compactedChangelogs = compactChangelog.size();
        this.rewriteInputFileSize = this.rewriteFileSize(compactBefore);
        this.rewriteOutputFileSize = this.rewriteFileSize(compactAfter);
        this.rewriteChangelogFileSize = this.rewriteFileSize(compactChangelog);
    }

    @VisibleForTesting
    protected long getDuration() {
        return this.duration;
    }

    protected long getCompactedDataFilesBefore() {
        return this.compactedDataFilesBefore;
    }

    protected long getCompactedDataFilesAfter() {
        return this.compactedDataFilesAfter;
    }

    protected long getCompactedChangelogs() {
        return this.compactedChangelogs;
    }

    protected long getRewriteInputFileSize() {
        return this.rewriteInputFileSize;
    }

    protected long getRewriteOutputFileSize() {
        return this.rewriteOutputFileSize;
    }

    protected long getRewriteChangelogFileSize() {
        return this.rewriteChangelogFileSize;
    }

    private long rewriteFileSize(List<DataFileMeta> files) {
        return files.stream().mapToLong(DataFileMeta::fileSize).sum();
    }

    public String toString() {
        return "CompactionStats{duration=" + this.duration + ", compactedDataFilesBefore=" + this.compactedDataFilesBefore + ", compactedDataFilesAfter=" + this.compactedDataFilesAfter + ", compactedChangelogs=" + this.compactedChangelogs + ", rewriteInputFileSize=" + this.rewriteInputFileSize + ", rewriteOutputFileSize=" + this.rewriteOutputFileSize + ", rewriteChangelogFileSize=" + this.rewriteChangelogFileSize + '}';
    }
}

