/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.paimon.shade.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.paimon.shade.org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.paimon.shade.org.apache.orc.CompressionCodec;
import org.apache.paimon.shade.org.apache.orc.DataReader;
import org.apache.paimon.shade.org.apache.orc.OrcProto;
import org.apache.paimon.shade.org.apache.orc.StripeInformation;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.shade.org.apache.orc.impl.BufferChunk;
import org.apache.paimon.shade.org.apache.orc.impl.BufferChunkList;
import org.apache.paimon.shade.org.apache.orc.impl.DataReaderProperties;
import org.apache.paimon.shade.org.apache.orc.impl.DirectDecompressionCodec;
import org.apache.paimon.shade.org.apache.orc.impl.HadoopShims;
import org.apache.paimon.shade.org.apache.orc.impl.HadoopShimsFactory;
import org.apache.paimon.shade.org.apache.orc.impl.InStream;
import org.apache.paimon.shade.org.apache.orc.impl.OrcCodecPool;
import org.apache.paimon.shade.org.apache.orc.impl.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReaderUtils {
    private static final HadoopShims SHIMS = HadoopShimsFactory.get();
    private static final Logger LOG = LoggerFactory.getLogger(RecordReaderUtils.class);
    private static final int BYTE_STREAM_POSITIONS = 1;
    private static final int RUN_LENGTH_BYTE_POSITIONS = 2;
    private static final int BITFIELD_POSITIONS = 3;
    private static final int RUN_LENGTH_INT_POSITIONS = 2;
    static final int WORST_UNCOMPRESSED_SLOP = 4098;
    static final int MAX_VALUES_LENGTH = 512;
    static final int MAX_BYTE_WIDTH = SerializationUtils.decodeBitWidth(SerializationUtils.FixedBitSizes.SIXTYFOUR.ordinal()) / 8;

    public static DataReader createDefaultDataReader(DataReaderProperties properties) {
        return new DefaultDataReader(properties);
    }

    static boolean overlap(long leftA, long rightA, long leftB, long rightB) {
        if (leftA <= leftB) {
            return rightA >= leftB;
        }
        return rightB >= leftA;
    }

    public static long estimateRgEndOffset(boolean isCompressed, int bufferSize, boolean isLast, long nextGroupOffset, long streamLength) {
        long slop = 4098L;
        if (isCompressed) {
            int stretchFactor = 2 + (512 * MAX_BYTE_WIDTH - 1) / bufferSize;
            slop = stretchFactor * (3 + bufferSize);
        }
        return isLast ? streamLength : Math.min(streamLength, nextGroupOffset + slop);
    }

    public static int getIndexPosition(OrcProto.ColumnEncoding.Kind columnEncoding, TypeDescription.Category columnType, OrcProto.Stream.Kind streamType, boolean isCompressed, boolean hasNulls) {
        if (streamType == OrcProto.Stream.Kind.PRESENT) {
            return 0;
        }
        int compressionValue = isCompressed ? 1 : 0;
        int base = hasNulls ? 3 + compressionValue : 0;
        switch (columnType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case STRUCT: 
            case MAP: 
            case LIST: 
            case UNION: {
                return base;
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                if (columnEncoding == OrcProto.ColumnEncoding.Kind.DICTIONARY || columnEncoding == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                    return base;
                }
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case BINARY: 
            case DECIMAL: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 2 + compressionValue;
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)columnType));
    }

    public static boolean isDictionary(OrcProto.Stream.Kind kind, OrcProto.ColumnEncoding encoding) {
        assert (kind != OrcProto.Stream.Kind.DICTIONARY_COUNT);
        OrcProto.ColumnEncoding.Kind encodingKind = encoding.getKind();
        return kind == OrcProto.Stream.Kind.DICTIONARY_DATA || kind == OrcProto.Stream.Kind.LENGTH && (encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY || encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2);
    }

    public static String stringifyDiskRanges(DiskRangeList range) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean isFirst = true;
        while (range != null) {
            if (!isFirst) {
                buffer.append(", {");
            } else {
                buffer.append("{");
            }
            isFirst = false;
            buffer.append(range.toString());
            buffer.append("}");
            range = range.next;
        }
        buffer.append("]");
        return buffer.toString();
    }

    static long computeEnd(BufferChunk first, BufferChunk last) {
        long end = 0L;
        BufferChunk ptr = first;
        while (ptr != last.next) {
            end = Math.max(ptr.getEnd(), end);
            ptr = (BufferChunk)ptr.next;
        }
        return end;
    }

    static void zeroCopyReadRanges(FSDataInputStream file, HadoopShims.ZeroCopyReaderShim zcr, BufferChunk first, BufferChunk last, boolean allocateDirect) throws IOException {
        ByteBuffer read;
        long offset = first.getOffset();
        file.seek(offset);
        ArrayList<ByteBuffer> bytes = new ArrayList<ByteBuffer>();
        for (int length = (int)(RecordReaderUtils.computeEnd(first, last) - offset); length > 0; length -= read.remaining()) {
            read = zcr.readBuffer(length, false);
            bytes.add(read);
        }
        long currentOffset = offset;
        BufferChunk current = first;
        Iterator buffers = bytes.iterator();
        ByteBuffer currentBuffer = (ByteBuffer)buffers.next();
        while (current != last.next) {
            if (current.getOffset() < offset) {
                buffers = bytes.iterator();
                currentBuffer = (ByteBuffer)buffers.next();
                currentOffset = offset;
            }
            while (currentOffset + (long)currentBuffer.remaining() <= current.getOffset()) {
                currentOffset += (long)currentBuffer.remaining();
                currentBuffer = (ByteBuffer)buffers.next();
            }
            if (currentOffset + (long)currentBuffer.remaining() >= current.getEnd()) {
                ByteBuffer copy = currentBuffer.duplicate();
                copy.position((int)(current.getOffset() - currentOffset));
                copy.limit(copy.position() + current.getLength());
                current.setChunk(copy);
            } else {
                ByteBuffer result = allocateDirect ? ByteBuffer.allocateDirect(current.getLength()) : ByteBuffer.allocate(current.getLength());
                ByteBuffer copy = currentBuffer.duplicate();
                copy.position((int)(current.getOffset() - currentOffset));
                result.put(copy);
                currentOffset += (long)currentBuffer.remaining();
                currentBuffer = (ByteBuffer)buffers.next();
                while (result.hasRemaining()) {
                    if (result.remaining() > currentBuffer.remaining()) {
                        result.put(currentBuffer.duplicate());
                        currentOffset += (long)currentBuffer.remaining();
                        currentBuffer = (ByteBuffer)buffers.next();
                        continue;
                    }
                    copy = currentBuffer.duplicate();
                    copy.limit(result.remaining());
                    result.put(copy);
                }
                result.flip();
                current.setChunk(result);
            }
            current = (BufferChunk)current.next;
        }
    }

    static void readRanges(FSDataInputStream file, BufferChunk first, BufferChunk last, boolean allocateDirect) throws IOException {
        ByteBuffer bytes;
        long offset = first.getOffset();
        int readSize = (int)(RecordReaderUtils.computeEnd(first, last) - offset);
        byte[] buffer = new byte[readSize];
        try {
            file.readFully(offset, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed while reading %s %d:%d", file, offset, buffer.length), e);
        }
        if (allocateDirect) {
            bytes = ByteBuffer.allocateDirect(readSize);
            bytes.put(buffer);
            bytes.flip();
        } else {
            bytes = ByteBuffer.wrap(buffer);
        }
        BufferChunk current = first;
        while (current != last.next) {
            ByteBuffer currentBytes = current == last ? bytes : bytes.duplicate();
            currentBytes.position((int)(current.getOffset() - offset));
            currentBytes.limit((int)(current.getEnd() - offset));
            current.setChunk(currentBytes);
            current = (BufferChunk)current.next;
        }
    }

    static BufferChunk findSingleRead(BufferChunk first) {
        return RecordReaderUtils.findSingleRead(first, 0L);
    }

    private static BufferChunk findSingleRead(BufferChunk first, long minSeekSize) {
        BufferChunk last = first;
        long currentEnd = first.getEnd();
        while (last.next != null && !last.next.hasData() && last.next.getOffset() <= currentEnd + minSeekSize && last.next.getEnd() - first.getOffset() < Integer.MAX_VALUE) {
            last = (BufferChunk)last.next;
            currentEnd = Math.max(currentEnd, last.getEnd());
        }
        return last;
    }

    static void readDiskRanges(FSDataInputStream file, HadoopShims.ZeroCopyReaderShim zcr, BufferChunkList list, boolean doForceDirect) throws IOException {
        RecordReaderUtils.readDiskRanges(file, zcr, list, doForceDirect, 0, 0.0);
    }

    private static void readDiskRanges(FSDataInputStream file, HadoopShims.ZeroCopyReaderShim zcr, BufferChunkList list, boolean doForceDirect, int minSeekSize, double minSeekSizeTolerance) throws IOException {
        BufferChunk current;
        BufferChunk bufferChunk = current = list == null ? null : list.get();
        while (current != null) {
            while (current.hasData()) {
                current = (BufferChunk)current.next;
            }
            if (zcr != null) {
                BufferChunk last = RecordReaderUtils.findSingleRead(current);
                RecordReaderUtils.zeroCopyReadRanges(file, zcr, current, last, doForceDirect);
                current = (BufferChunk)last.next;
                continue;
            }
            ChunkReader chunkReader = ChunkReader.create(current, minSeekSize);
            chunkReader.readRanges(file, doForceDirect, minSeekSizeTolerance);
            current = (BufferChunk)((ChunkReader)chunkReader).to.next;
        }
    }

    static HadoopShims.ZeroCopyReaderShim createZeroCopyShim(FSDataInputStream file, CompressionCodec codec, ByteBufferAllocatorPool pool) throws IOException {
        if (codec == null || codec instanceof DirectDecompressionCodec && ((DirectDecompressionCodec)codec).isAvailable()) {
            return SHIMS.getZeroCopyReader(file, pool);
        }
        return null;
    }

    static class ChunkReader {
        private final BufferChunk from;
        private final BufferChunk to;
        private final int readBytes;
        private final int reqBytes;

        private ChunkReader(BufferChunk from, BufferChunk to, int readSize, int reqBytes) {
            this.from = from;
            this.to = to;
            this.readBytes = readSize;
            this.reqBytes = reqBytes;
        }

        double getExtraBytesFraction() {
            return (double)(this.readBytes - this.reqBytes) / (double)this.reqBytes;
        }

        public int getReadBytes() {
            return this.readBytes;
        }

        public int getReqBytes() {
            return this.reqBytes;
        }

        public BufferChunk getFrom() {
            return this.from;
        }

        public BufferChunk getTo() {
            return this.to;
        }

        void populateChunks(ByteBuffer bytes, boolean allocateDirect, double extraByteTolerance) {
            if (this.getExtraBytesFraction() > extraByteTolerance) {
                LOG.debug("ExtraBytesFraction = {}, ExtraByteTolerance = {}, reducing memory size", (Object)this.getExtraBytesFraction(), (Object)extraByteTolerance);
                this.populateChunksReduceSize(bytes, allocateDirect);
            } else {
                LOG.debug("ExtraBytesFraction = {}, ExtraByteTolerance = {}, populating as is", (Object)this.getExtraBytesFraction(), (Object)extraByteTolerance);
                this.populateChunksAsIs(bytes);
            }
        }

        void populateChunksAsIs(ByteBuffer bytes) {
            BufferChunk current = this.from;
            long offset = this.from.getOffset();
            while (current != this.to.next) {
                ByteBuffer currentBytes = current == this.to ? bytes : bytes.duplicate();
                currentBytes.position((int)(current.getOffset() - offset));
                currentBytes.limit((int)(current.getEnd() - offset));
                current.setChunk(currentBytes);
                current = (BufferChunk)current.next;
            }
        }

        void populateChunksReduceSize(ByteBuffer bytes, boolean allocateDirect) {
            ByteBuffer newBuffer;
            if (allocateDirect) {
                newBuffer = ByteBuffer.allocateDirect(this.reqBytes);
                newBuffer.position(this.reqBytes);
                newBuffer.flip();
            } else {
                byte[] newBytes = new byte[this.reqBytes];
                newBuffer = ByteBuffer.wrap(newBytes);
            }
            long offset = this.from.getOffset();
            int copyStart = 0;
            int skippedBytes = 0;
            BufferChunk current = this.from;
            while (current != this.to.next) {
                int copyEnd;
                int srcPosition = (int)(current.getOffset() - offset);
                skippedBytes += Math.max(0, srcPosition - copyStart);
                int copyLength = (copyStart = Math.max(copyStart, srcPosition)) < (copyEnd = (int)(current.getEnd() - offset)) ? copyEnd - copyStart : 0;
                newBuffer.put(bytes.array(), copyStart, copyLength);
                copyStart += copyLength;
                ByteBuffer currentBytes = current == this.to ? newBuffer : newBuffer.duplicate();
                currentBytes.position(srcPosition - skippedBytes);
                currentBytes.limit(currentBytes.position() + current.getLength());
                current.setChunk(currentBytes);
                current = (BufferChunk)current.next;
            }
        }

        void readRanges(FSDataInputStream file, boolean allocateDirect, double extraByteTolerance) throws IOException {
            ByteBuffer bytes;
            long offset = this.from.getOffset();
            int readSize = (int)(RecordReaderUtils.computeEnd(this.from, this.to) - offset);
            byte[] buffer = new byte[readSize];
            try {
                file.readFully(offset, buffer, 0, buffer.length);
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed while reading %s %d:%d", file, offset, buffer.length), e);
            }
            if (allocateDirect) {
                bytes = ByteBuffer.allocateDirect(readSize);
                bytes.put(buffer);
                bytes.flip();
            } else {
                bytes = ByteBuffer.wrap(buffer);
            }
            this.populateChunks(bytes, allocateDirect, extraByteTolerance);
        }

        static ChunkReader create(BufferChunk from, BufferChunk to) {
            long f = Integer.MAX_VALUE;
            long e = Integer.MIN_VALUE;
            long cf = Integer.MAX_VALUE;
            long ef = Integer.MIN_VALUE;
            int reqBytes = 0;
            BufferChunk current = from;
            while (current != to.next) {
                f = Math.min(f, current.getOffset());
                e = Math.max(e, current.getEnd());
                if (ef == Integer.MIN_VALUE || current.getOffset() <= ef) {
                    cf = Math.min(cf, current.getOffset());
                    ef = Math.max(ef, current.getEnd());
                } else {
                    reqBytes = (int)((long)reqBytes + (ef - cf));
                    cf = current.getOffset();
                    ef = current.getEnd();
                }
                current = (BufferChunk)current.next;
            }
            reqBytes = (int)((long)reqBytes + (ef - cf));
            return new ChunkReader(from, to, (int)(e - f), reqBytes);
        }

        static ChunkReader create(BufferChunk from, int minSeekSize) {
            BufferChunk to = RecordReaderUtils.findSingleRead(from, minSeekSize);
            return ChunkReader.create(from, to);
        }
    }

    public static final class ByteBufferAllocatorPool
    implements HadoopShims.ByteBufferPoolShim {
        private final TreeMap<Key, ByteBuffer> buffers = new TreeMap();
        private final TreeMap<Key, ByteBuffer> directBuffers = new TreeMap();
        private long currentGeneration = 0L;

        private TreeMap<Key, ByteBuffer> getBufferTree(boolean direct) {
            return direct ? this.directBuffers : this.buffers;
        }

        public void clear() {
            this.buffers.clear();
            this.directBuffers.clear();
        }

        @Override
        public ByteBuffer getBuffer(boolean direct, int length) {
            TreeMap<Key, ByteBuffer> tree = this.getBufferTree(direct);
            Map.Entry<Key, ByteBuffer> entry = tree.ceilingEntry(new Key(length, 0L));
            if (entry == null) {
                return direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
            }
            tree.remove(entry.getKey());
            return entry.getValue();
        }

        @Override
        public void putBuffer(ByteBuffer buffer) {
            Key key;
            TreeMap<Key, ByteBuffer> tree = this.getBufferTree(buffer.isDirect());
            while (tree.putIfAbsent(key = new Key(buffer.capacity(), this.currentGeneration++), buffer) != null) {
            }
        }

        private static final class Key
        implements Comparable<Key> {
            private final int capacity;
            private final long insertionGeneration;

            Key(int capacity, long insertionGeneration) {
                this.capacity = capacity;
                this.insertionGeneration = insertionGeneration;
            }

            @Override
            public int compareTo(Key other) {
                int c = Integer.compare(this.capacity, other.capacity);
                return c != 0 ? c : Long.compare(this.insertionGeneration, other.insertionGeneration);
            }

            public boolean equals(Object rhs) {
                if (rhs instanceof Key) {
                    Key o = (Key)rhs;
                    return 0 == this.compareTo(o);
                }
                return false;
            }

            public int hashCode() {
                return new HashCodeBuilder().append(this.capacity).append(this.insertionGeneration).toHashCode();
            }
        }
    }

    private static class DefaultDataReader
    implements DataReader {
        private FSDataInputStream file;
        private ByteBufferAllocatorPool pool;
        private HadoopShims.ZeroCopyReaderShim zcr = null;
        private final Supplier<FileSystem> fileSystemSupplier;
        private final Path path;
        private final boolean useZeroCopy;
        private final int minSeekSize;
        private final double minSeekSizeTolerance;
        private InStream.StreamOptions options;
        private boolean isOpen = false;

        private DefaultDataReader(DataReaderProperties properties) {
            this.fileSystemSupplier = properties.getFileSystemSupplier();
            this.path = properties.getPath();
            this.file = properties.getFile();
            this.useZeroCopy = properties.getZeroCopy();
            this.options = properties.getCompression();
            this.minSeekSize = properties.getMinSeekSize();
            this.minSeekSizeTolerance = properties.getMinSeekSizeTolerance();
        }

        @Override
        public void open() throws IOException {
            if (this.file == null) {
                this.file = this.fileSystemSupplier.get().open(this.path);
            }
            if (this.useZeroCopy) {
                this.pool = new ByteBufferAllocatorPool();
                this.zcr = RecordReaderUtils.createZeroCopyShim(this.file, this.options.getCodec(), this.pool);
            } else {
                this.zcr = null;
            }
            this.isOpen = true;
        }

        @Override
        public OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
            if (!this.isOpen) {
                this.open();
            }
            long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
            int tailLength = (int)stripe.getFooterLength();
            ByteBuffer tailBuf = ByteBuffer.allocate(tailLength);
            this.file.readFully(offset, tailBuf.array(), tailBuf.arrayOffset(), tailLength);
            return OrcProto.StripeFooter.parseFrom(InStream.createCodedInputStream(InStream.create("footer", new BufferChunk(tailBuf, 0L), 0L, tailLength, this.options)));
        }

        @Override
        public BufferChunkList readFileData(BufferChunkList range, boolean doForceDirect) throws IOException {
            RecordReaderUtils.readDiskRanges(this.file, this.zcr, range, doForceDirect, this.minSeekSize, this.minSeekSizeTolerance);
            return range;
        }

        @Override
        public void close() throws IOException {
            if (this.options.getCodec() != null) {
                OrcCodecPool.returnCodec(this.options.getCodec().getKind(), this.options.getCodec());
                this.options.withCodec(null);
            }
            if (this.pool != null) {
                this.pool.clear();
            }
            try (HadoopShims.ZeroCopyReaderShim myZcr = this.zcr;){
                if (this.file != null) {
                    this.file.close();
                    this.file = null;
                }
            }
        }

        @Override
        public boolean isTrackingDiskRanges() {
            return this.zcr != null;
        }

        @Override
        public void releaseBuffer(ByteBuffer buffer) {
            this.zcr.releaseBuffer(buffer);
        }

        @Override
        public DataReader clone() {
            if (this.file != null) {
                LOG.warn("Cloning an opened DataReader; the stream will be reused and closed twice");
            }
            try {
                DefaultDataReader clone = (DefaultDataReader)super.clone();
                if (this.options.getCodec() != null) {
                    clone.options = this.options.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException("uncloneable", e);
            }
        }

        @Override
        public InStream.StreamOptions getCompressionOptions() {
            return this.options;
        }
    }
}

