/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.query;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueFileStore;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.lookup.LookupStoreFactory;
import org.apache.paimon.lookup.hash.HashLookupStoreFactory;
import org.apache.paimon.mergetree.Levels;
import org.apache.paimon.mergetree.LookupLevels;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.query.TableQuery;
import org.apache.paimon.utils.KeyComparatorSupplier;
import org.apache.paimon.utils.Preconditions;

public class LocalTableQuery
implements TableQuery {
    private final Map<BinaryRow, Map<Integer, LookupLevels>> tableView;
    private final CoreOptions options;
    private final Supplier<Comparator<InternalRow>> keyComparatorSupplier;
    private final KeyValueFileReaderFactory.Builder readerFactoryBuilder;
    private final HashLookupStoreFactory hashLookupStoreFactory;
    private final int startLevel;
    private IOManager ioManager;

    public LocalTableQuery(FileStoreTable table) {
        this.options = table.coreOptions();
        this.tableView = new HashMap<BinaryRow, Map<Integer, LookupLevels>>();
        FileStore<?> tableStore = table.store();
        if (!(tableStore instanceof KeyValueFileStore)) {
            throw new UnsupportedOperationException("Table Query only supports table with primary key.");
        }
        KeyValueFileStore store = (KeyValueFileStore)tableStore;
        this.readerFactoryBuilder = store.newReaderFactoryBuilder();
        this.keyComparatorSupplier = new KeyComparatorSupplier(this.readerFactoryBuilder.keyType());
        this.hashLookupStoreFactory = new HashLookupStoreFactory(new CacheManager(this.options.lookupCacheMaxMemory()), this.options.cachePageSize(), this.options.toConfiguration().get(CoreOptions.LOOKUP_HASH_LOAD_FACTOR).floatValue());
        if (this.options.changelogProducer() == CoreOptions.ChangelogProducer.LOOKUP) {
            this.startLevel = 1;
        } else {
            if (this.options.sequenceField().isPresent()) {
                throw new UnsupportedOperationException("Not support sequence field definition, but is: " + this.options.sequenceField().get());
            }
            if (this.options.mergeEngine() != CoreOptions.MergeEngine.DEDUPLICATE) {
                throw new UnsupportedOperationException("Only support deduplicate merge engine, but is: " + this.options.mergeEngine());
            }
            this.startLevel = 0;
        }
    }

    public void refreshFiles(BinaryRow partition, int bucket, List<DataFileMeta> beforeFiles, List<DataFileMeta> dataFiles) {
        LookupLevels lookupLevels = (LookupLevels)this.tableView.computeIfAbsent(partition, k -> new HashMap()).get(bucket);
        if (lookupLevels == null) {
            Preconditions.checkArgument(beforeFiles.isEmpty(), "The before file should be empty for the initial phase.");
            this.newLookupLevels(partition, bucket, dataFiles);
        } else {
            lookupLevels.getLevels().update(beforeFiles, dataFiles);
        }
    }

    private void newLookupLevels(BinaryRow partition, int bucket, List<DataFileMeta> dataFiles) {
        Levels levels = new Levels(this.keyComparatorSupplier.get(), dataFiles, this.options.numLevels());
        KeyValueFileReaderFactory factory = this.readerFactoryBuilder.build(partition, bucket);
        Options options = this.options.toConfiguration();
        LookupLevels lookupLevels = new LookupLevels(levels, this.keyComparatorSupplier.get(), this.readerFactoryBuilder.keyType(), this.readerFactoryBuilder.projectedValueType(), file -> factory.createRecordReader(file.schemaId(), file.fileName(), file.fileSize(), file.level()), () -> Preconditions.checkNotNull(this.ioManager, "IOManager is required.").createChannel().getPathFile(), this.hashLookupStoreFactory, options.get(CoreOptions.LOOKUP_CACHE_FILE_RETENTION), options.get(CoreOptions.LOOKUP_CACHE_MAX_DISK_SIZE), LookupStoreFactory.bfGenerator(options));
        this.tableView.computeIfAbsent(partition, k -> new HashMap()).put(bucket, lookupLevels);
    }

    @Override
    @Nullable
    public synchronized InternalRow lookup(BinaryRow partition, int bucket, InternalRow key) throws IOException {
        Map<Integer, LookupLevels> buckets = this.tableView.get(partition);
        if (buckets == null || buckets.isEmpty()) {
            return null;
        }
        LookupLevels lookupLevels = buckets.get(bucket);
        if (lookupLevels == null) {
            return null;
        }
        KeyValue kv = lookupLevels.lookup(key, this.startLevel);
        if (kv == null || kv.valueKind().isRetract()) {
            return null;
        }
        return kv.value();
    }

    @Override
    public LocalTableQuery withValueProjection(int[][] projection) {
        this.readerFactoryBuilder.withValueProjection(projection);
        return this;
    }

    public LocalTableQuery withIOManager(IOManager ioManager) {
        this.ioManager = ioManager;
        return this;
    }

    @Override
    public InternalRowSerializer createValueSerializer() {
        return InternalSerializers.create(this.readerFactoryBuilder.projectedValueType());
    }

    @Override
    public void close() throws IOException {
        for (Map.Entry<BinaryRow, Map<Integer, LookupLevels>> buckets : this.tableView.entrySet()) {
            for (Map.Entry<Integer, LookupLevels> bucket : buckets.getValue().entrySet()) {
                bucket.getValue().close();
            }
        }
        this.tableView.clear();
    }
}

