/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.BitSet;
import org.apache.paimon.utils.Preconditions;

public class BloomFilter {
    protected BitSet bitSet;
    protected long expectedEntries;
    protected int numHashFunctions;

    public BloomFilter(long expectedEntries, int byteSize) {
        Preconditions.checkArgument(expectedEntries > 0L, "expectedEntries should be > 0");
        this.expectedEntries = expectedEntries;
        this.numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedEntries, (long)byteSize << 3);
        this.bitSet = new BitSet(byteSize);
    }

    public void setMemorySegment(MemorySegment memorySegment, int offset) {
        this.bitSet.setMemorySegment(memorySegment, offset);
    }

    public void unsetMemorySegment() {
        this.bitSet.unsetMemorySegment();
    }

    public MemorySegment getMemorySegment() {
        return this.bitSet.getMemorySegment();
    }

    public static int optimalNumOfBits(long inputEntries, double fpp) {
        return (int)((double)(-inputEntries) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
    }

    static int optimalNumOfHashFunctions(long expectEntries, long bitSize) {
        return Math.max(1, (int)Math.round((double)bitSize / (double)expectEntries * Math.log(2.0)));
    }

    public void addHash(int hash1) {
        int hash2 = hash1 >>> 16;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int pos = combinedHash % this.bitSet.bitSize();
            this.bitSet.set(pos);
        }
    }

    public boolean testHash(int hash1) {
        int hash2 = hash1 >>> 16;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int pos;
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bitSet.get(pos = combinedHash % this.bitSet.bitSize())) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.bitSet.clear();
    }

    public String toString() {
        return "BloomFilter:\n\thash function number:" + this.numHashFunctions + "\n" + this.bitSet;
    }

    public static Builder builder(long expectedRow, double fpp) {
        int numBytes = (int)Math.ceil((double)BloomFilter.optimalNumOfBits(expectedRow, fpp) / 8.0);
        Preconditions.checkArgument(numBytes > 0, "The optimal bits should > 0. expectedRow: %s, fpp: %s", expectedRow, fpp);
        return new Builder(MemorySegment.wrap(new byte[numBytes]), expectedRow);
    }

    public static class Builder {
        private final MemorySegment buffer;
        private final BloomFilter filter;
        private final long numRecords;

        Builder(MemorySegment buffer, long numRecords) {
            this.buffer = buffer;
            this.filter = new BloomFilter(numRecords, buffer.size());
            this.filter.setMemorySegment(buffer, 0);
            this.numRecords = numRecords;
        }

        public boolean testHash(int hash) {
            return this.filter.testHash(hash);
        }

        public void addHash(int hash) {
            this.filter.addHash(hash);
        }

        public MemorySegment getBuffer() {
            return this.buffer;
        }

        public long getNumRecords() {
            return this.numRecords;
        }

        @VisibleForTesting
        public BloomFilter getFilter() {
            return this.filter;
        }
    }
}

