/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagManager {
    private static final Logger LOG = LoggerFactory.getLogger(TagManager.class);
    private static final String TAG_PREFIX = "tag-";
    private final FileIO fileIO;
    private final Path tablePath;

    public TagManager(FileIO fileIO, Path tablePath) {
        this.fileIO = fileIO;
        this.tablePath = tablePath;
    }

    public Path tagDirectory() {
        return new Path(this.tablePath + "/tag");
    }

    public Path tagPath(String tagName) {
        return new Path(this.tablePath + "/tag/" + TAG_PREFIX + tagName);
    }

    public Path branchTagPath(String branchName, String tagName) {
        return new Path(BranchManager.getBranchPath(this.tablePath, branchName) + "/tag/" + TAG_PREFIX + tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTag(Snapshot snapshot, String tagName, List<TagCallback> callbacks) {
        Preconditions.checkArgument(!StringUtils.isBlank(tagName), "Tag name '%s' is blank.", tagName);
        Preconditions.checkArgument(!this.tagExists(tagName), "Tag name '%s' already exists.", tagName);
        Path newTagPath = this.tagPath(tagName);
        try {
            this.fileIO.writeFileUtf8(newTagPath, snapshot.toJson());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when committing tag '%s' (path %s). Cannot clean up because we can't determine the success.", tagName, newTagPath), e);
        }
        try {
            callbacks.forEach(callback -> callback.notifyCreation(tagName));
        }
        finally {
            for (TagCallback tagCallback : callbacks) {
                IOUtils.closeQuietly(tagCallback);
            }
        }
    }

    public void deleteAllTagsOfOneSnapshot(List<String> tagNames, TagDeletion tagDeletion, SnapshotManager snapshotManager) {
        Snapshot taggedSnapshot = this.taggedSnapshot(tagNames.get(0));
        if (snapshotManager.snapshotExists(taggedSnapshot.id())) {
            tagNames.forEach(tagName -> this.fileIO.deleteQuietly(this.tagPath((String)tagName)));
            return;
        }
        List<Snapshot> taggedSnapshots = this.taggedSnapshots();
        tagNames.forEach(tagName -> this.fileIO.deleteQuietly(this.tagPath((String)tagName)));
        this.doClean(taggedSnapshot, taggedSnapshots, snapshotManager, tagDeletion);
    }

    public void deleteTag(String tagName, TagDeletion tagDeletion, SnapshotManager snapshotManager) {
        Preconditions.checkArgument(!StringUtils.isBlank(tagName), "Tag name '%s' is blank.", tagName);
        Preconditions.checkArgument(this.tagExists(tagName), "Tag '%s' doesn't exist.", tagName);
        Snapshot taggedSnapshot = this.taggedSnapshot(tagName);
        if (snapshotManager.snapshotExists(taggedSnapshot.id())) {
            this.fileIO.deleteQuietly(this.tagPath(tagName));
            return;
        }
        SortedMap<Snapshot, List<String>> tags = this.tags();
        this.fileIO.deleteQuietly(this.tagPath(tagName));
        if (((List)tags.get(taggedSnapshot)).size() > 1) {
            return;
        }
        ArrayList<Snapshot> taggedSnapshots = new ArrayList<Snapshot>(tags.keySet());
        this.doClean(taggedSnapshot, taggedSnapshots, snapshotManager, tagDeletion);
    }

    private void doClean(Snapshot taggedSnapshot, List<Snapshot> taggedSnapshots, SnapshotManager snapshotManager, TagDeletion tagDeletion) {
        ArrayList<Snapshot> skippedSnapshots = new ArrayList<Snapshot>();
        int index = this.findIndex(taggedSnapshot, taggedSnapshots);
        if (index - 1 >= 0) {
            skippedSnapshots.add(taggedSnapshots.get(index - 1));
        }
        Snapshot right = snapshotManager.earliestSnapshot();
        if (index + 1 < taggedSnapshots.size()) {
            Snapshot rightTag = taggedSnapshots.get(index + 1);
            right = right.id() < rightTag.id() ? right : rightTag;
        }
        skippedSnapshots.add(right);
        Predicate<ManifestEntry> dataFileSkipper = null;
        boolean success = true;
        try {
            dataFileSkipper = tagDeletion.dataFileSkipper(skippedSnapshots);
        }
        catch (Exception e) {
            LOG.info(String.format("Skip cleaning data files for tag of snapshot %s due to failed to build skipping set.", taggedSnapshot.id()), (Throwable)e);
            success = false;
        }
        if (success) {
            tagDeletion.cleanUnusedDataFiles(taggedSnapshot, dataFileSkipper);
            tagDeletion.cleanDataDirectories();
        }
        tagDeletion.cleanUnusedManifests(taggedSnapshot, tagDeletion.manifestSkippingSet(skippedSnapshots));
    }

    public boolean tagExists(String tagName) {
        Path path = this.tagPath(tagName);
        try {
            return this.fileIO.exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to determine if tag '%s' exists in path %s.", tagName, path), e);
        }
    }

    public Snapshot taggedSnapshot(String tagName) {
        Preconditions.checkArgument(this.tagExists(tagName), "Tag '%s' doesn't exist.", tagName);
        return Snapshot.fromPath(this.fileIO, this.tagPath(tagName));
    }

    public long tagCount() {
        try {
            return FileUtils.listVersionedFileStatus(this.fileIO, this.tagDirectory(), TAG_PREFIX).count();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Snapshot> taggedSnapshots() {
        return new ArrayList<Snapshot>(this.tags().keySet());
    }

    public SortedMap<Snapshot, List<String>> tags() {
        return this.tags(tagName -> true);
    }

    public SortedMap<Snapshot, List<String>> tags(Predicate<String> filter) {
        TreeMap<Snapshot, List<String>> tags = new TreeMap<Snapshot, List<String>>(Comparator.comparingLong(Snapshot::id));
        try {
            List paths = FileUtils.listVersionedFileStatus(this.fileIO, this.tagDirectory(), TAG_PREFIX).map(FileStatus::getPath).collect(Collectors.toList());
            for (Path path : paths) {
                String tagName = path.getName().substring(TAG_PREFIX.length());
                if (!filter.test(tagName)) continue;
                Snapshot.safelyFromPath(this.fileIO, path).ifPresent(snapshot -> tags.computeIfAbsent((Snapshot)snapshot, s -> new ArrayList()).add(tagName));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tags;
    }

    public List<String> sortTagsOfOneSnapshot(List<String> tagNames) {
        return tagNames.stream().map(name -> {
            try {
                return this.fileIO.getFileStatus(this.tagPath((String)name));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).sorted(Comparator.comparingLong(FileStatus::getModificationTime)).map(fileStatus -> fileStatus.getPath().getName().substring(TAG_PREFIX.length())).collect(Collectors.toList());
    }

    @VisibleForTesting
    public List<String> allTagNames() {
        return this.tags().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private int findIndex(Snapshot taggedSnapshot, List<Snapshot> taggedSnapshots) {
        for (int i = 0; i < taggedSnapshots.size(); ++i) {
            if (taggedSnapshot.id() != taggedSnapshots.get(i).id()) continue;
            return i;
        }
        throw new RuntimeException(String.format("Didn't find tag with snapshot id '%s'.This is unexpected.", taggedSnapshot.id()));
    }

    public static List<Snapshot> findOverlappedSnapshots(List<Snapshot> taggedSnapshots, long beginInclusive, long endExclusive) {
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        int right = TagManager.findPreviousTag(taggedSnapshots, endExclusive);
        if (right >= 0) {
            int left;
            for (int i = left = Math.max(TagManager.findPreviousOrEqualTag(taggedSnapshots, beginInclusive), 0); i <= right; ++i) {
                snapshots.add(taggedSnapshots.get(i));
            }
        }
        return snapshots;
    }

    public static int findPreviousTag(List<Snapshot> taggedSnapshots, long targetSnapshotId) {
        for (int i = taggedSnapshots.size() - 1; i >= 0; --i) {
            if (taggedSnapshots.get(i).id() >= targetSnapshotId) continue;
            return i;
        }
        return -1;
    }

    private static int findPreviousOrEqualTag(List<Snapshot> taggedSnapshots, long targetSnapshotId) {
        for (int i = taggedSnapshots.size() - 1; i >= 0; --i) {
            if (taggedSnapshots.get(i).id() > targetSnapshotId) continue;
            return i;
        }
        return -1;
    }
}

