/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.append;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.operation.AppendOnlyFileStoreWrite;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.utils.Preconditions;

public class AppendOnlyCompactionTask {
    private final BinaryRow partition;
    private final List<DataFileMeta> compactBefore;
    private final List<DataFileMeta> compactAfter;

    public AppendOnlyCompactionTask(BinaryRow partition, List<DataFileMeta> files) {
        Preconditions.checkArgument(files != null && files.size() > 1, "AppendOnlyCompactionTask need more than one file input.");
        this.partition = partition;
        this.compactBefore = new ArrayList<DataFileMeta>(files);
        this.compactAfter = new ArrayList<DataFileMeta>();
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public List<DataFileMeta> compactBefore() {
        return this.compactBefore;
    }

    public List<DataFileMeta> compactAfter() {
        return this.compactAfter;
    }

    public CommitMessage doCompact(AppendOnlyFileStoreWrite write) throws Exception {
        this.compactAfter.addAll(write.compactRewriter(this.partition, 0).rewrite(this.compactBefore));
        CompactIncrement compactIncrement = new CompactIncrement(this.compactBefore, this.compactAfter, Collections.emptyList());
        return new CommitMessageImpl(this.partition, 0, DataIncrement.emptyIncrement(), compactIncrement);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.compactBefore, this.compactAfter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppendOnlyCompactionTask that = (AppendOnlyCompactionTask)o;
        return Objects.equals(this.partition, that.partition) && Objects.equals(this.compactBefore, that.compactBefore) && Objects.equals(this.compactAfter, that.compactAfter);
    }

    public String toString() {
        return String.format("CompactionTask {partition = %s, compactBefore = %s, compactAfter = %s}", this.partition, this.compactBefore, this.compactAfter);
    }
}

