/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.format;

import java.util.List;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.format.RecordParser;
import org.apache.paimon.flink.action.cdc.format.RecordParserFactory;
import org.apache.paimon.flink.action.cdc.format.canal.CanalRecordParser;
import org.apache.paimon.flink.action.cdc.format.debezium.DebeziumRecordParser;
import org.apache.paimon.flink.action.cdc.format.maxwell.MaxwellRecordParser;
import org.apache.paimon.flink.action.cdc.format.ogg.OggRecordParser;

public enum DataFormat {
    CANAL_JSON(CanalRecordParser::new),
    OGG_JSON(OggRecordParser::new),
    MAXWELL_JSON(MaxwellRecordParser::new),
    DEBEZIUM_JSON(DebeziumRecordParser::new);

    private final RecordParserFactory parser;

    private DataFormat(RecordParserFactory parser) {
        this.parser = parser;
    }

    public RecordParser createParser(boolean caseSensitive, TypeMapping typeMapping, List<ComputedColumn> computedColumns) {
        return this.parser.createParser(caseSensitive, typeMapping, computedColumns);
    }

    public static DataFormat fromConfigString(String format) {
        try {
            return DataFormat.valueOf(format.replace("-", "_").toUpperCase());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("This format: %s is not supported.", format));
        }
    }
}

