/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.mongodb.strategy.Mongo4VersionStrategy;
import org.apache.paimon.flink.action.cdc.mongodb.strategy.MongoVersionStrategy;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class MongoDBRecordParser
implements FlatMapFunction<CdcSourceRecord, RichCdcMultiplexRecord> {
    private static final String FIELD_DATABASE = "db";
    private static final String FIELD_TABLE = "coll";
    private static final String FIELD_NAMESPACE = "ns";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final List<ComputedColumn> computedColumns;
    private final boolean caseSensitive;
    private final Configuration mongodbConfig;
    private JsonNode root;

    public MongoDBRecordParser(boolean caseSensitive, List<ComputedColumn> computedColumns, Configuration mongodbConfig) {
        this.caseSensitive = caseSensitive;
        this.computedColumns = computedColumns;
        this.mongodbConfig = mongodbConfig;
    }

    public void flatMap(CdcSourceRecord value, Collector<RichCdcMultiplexRecord> out) throws Exception {
        this.root = OBJECT_MAPPER.readValue((String)value.getValue(), JsonNode.class);
        String databaseName = this.extractString(FIELD_DATABASE);
        String collection = this.extractString(FIELD_TABLE);
        MongoVersionStrategy versionStrategy = VersionStrategyFactory.create(databaseName, collection, this.caseSensitive, this.computedColumns, this.mongodbConfig);
        versionStrategy.extractRecords(this.root).forEach(arg_0 -> out.collect(arg_0));
    }

    private String extractString(String key) {
        return this.root.get(FIELD_NAMESPACE).get(key).asText();
    }

    private static class VersionStrategyFactory {
        private VersionStrategyFactory() {
        }

        static MongoVersionStrategy create(String databaseName, String collection, boolean caseSensitive, List<ComputedColumn> computedColumns, Configuration mongodbConfig) {
            return new Mongo4VersionStrategy(databaseName, collection, caseSensitive, computedColumns, mongodbConfig);
        }
    }
}

