/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.DropPartitionAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.utils.Preconditions;

public class DropPartitionActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "drop_partition";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Preconditions.checkArgument(params.has("partition"), "Argument '%s' is required. Run '<action> --help' for help.", "partition");
        List<Map<String, String>> partitions = this.getPartitions(params);
        return Optional.of(new DropPartitionAction(params.getRequired("database"), params.getRequired("table"), partitions, this.catalogConfigMap(params)));
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"drop_partition\" drops data of specified partitions for a table.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  drop_partition --warehouse <warehouse_path> --database <database_name> --table <table_name> --partition <partition_name> [--partition <partition_name> ...]");
        System.out.println("  drop_partition --path <table_path> --partition <partition_name> [--partition <partition_name> ...]");
        System.out.println();
        System.out.println("Partition name syntax:");
        System.out.println("  key1=value1,key2=value2,...");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  drop_partition --warehouse hdfs:///path/to/warehouse --database test_db --table test_table --partition dt=20221126,hh=08");
        System.out.println("  drop_partition --path hdfs:///path/to/warehouse/test_db.db/test_table --partition dt=20221126,hh=08 --partition dt=20221127,hh=09");
    }
}

