/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Collections;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.table.FileStoreTable;

public class CompactManifestProcedure
extends ProcedureBase {
    private static final String COMMIT_USER = "Compact-Manifest-Procedure-Committer";

    @Override
    public String identifier() {
        return "compact_manifest";
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING"))})
    public String[] call(ProcedureContext procedureContext, String tableId) throws Exception {
        FileStoreTable table = (FileStoreTable)this.table(tableId).copy(Collections.singletonMap(CoreOptions.COMMIT_USER_PREFIX.key(), COMMIT_USER));
        try (FileStoreCommit commit = table.store().newCommit(table.coreOptions().createCommitUser()).ignoreEmptyCommit(false);){
            commit.compactManifest();
        }
        return new String[]{"success"};
    }
}

