/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.sink.StoreSinkWriteImpl;
import org.apache.paimon.flink.sink.StoreSinkWriteState;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.table.FileStoreTable;

public class AsyncLookupSinkWrite
extends StoreSinkWriteImpl {
    private static final String ACTIVE_BUCKETS_STATE_NAME = "paimon_async_lookup_active_buckets";
    private final String tableName;

    public AsyncLookupSinkWrite(FileStoreTable table, String commitUser, StoreSinkWriteState state, IOManager ioManager, boolean ignorePreviousFiles, boolean waitCompaction, boolean isStreaming, @Nullable MemorySegmentPool memoryPool, MetricGroup metricGroup) {
        super(table, commitUser, state, ioManager, ignorePreviousFiles, waitCompaction, isStreaming, memoryPool, metricGroup);
        this.tableName = table.name();
        List<StoreSinkWriteState.StateValue> activeBucketsStateValues = state.get(this.tableName, ACTIVE_BUCKETS_STATE_NAME);
        if (activeBucketsStateValues != null) {
            for (StoreSinkWriteState.StateValue stateValue : activeBucketsStateValues) {
                try {
                    this.write.compact(stateValue.partition(), stateValue.bucket(), false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void snapshotState() throws Exception {
        super.snapshotState();
        ArrayList<StoreSinkWriteState.StateValue> activeBucketsList = new ArrayList<StoreSinkWriteState.StateValue>();
        for (Map.Entry<BinaryRow, List<Integer>> partitions : ((AbstractFileStoreWrite)this.write.getWrite()).getActiveBuckets().entrySet()) {
            for (int bucket : partitions.getValue()) {
                activeBucketsList.add(new StoreSinkWriteState.StateValue(partitions.getKey(), bucket, new byte[0]));
            }
        }
        this.state.put(this.tableName, ACTIVE_BUCKETS_STATE_NAME, activeBucketsList);
    }
}

