/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.metrics.groups.OperatorMetricGroup;

public interface Committer<CommitT, GlobalCommitT>
extends AutoCloseable {
    public boolean forceCreatingSnapshot();

    public GlobalCommitT combine(long var1, long var3, List<CommitT> var5) throws IOException;

    public GlobalCommitT combine(long var1, long var3, GlobalCommitT var5, List<CommitT> var6);

    public void commit(List<GlobalCommitT> var1) throws IOException, InterruptedException;

    public int filterAndCommit(List<GlobalCommitT> var1, boolean var2) throws IOException;

    default public int filterAndCommit(List<GlobalCommitT> globalCommittables) throws IOException {
        return this.filterAndCommit(globalCommittables, true);
    }

    public Map<Long, List<CommitT>> groupByCheckpoint(Collection<CommitT> var1);

    public static Context createContext(final String commitUser, final @Nullable OperatorMetricGroup metricGroup, final boolean streamingCheckpointEnabled, final boolean isRestored, final OperatorStateStore stateStore) {
        return new Context(){

            @Override
            public String commitUser() {
                return commitUser;
            }

            @Override
            public OperatorMetricGroup metricGroup() {
                return metricGroup;
            }

            @Override
            public boolean streamingCheckpointEnabled() {
                return streamingCheckpointEnabled;
            }

            @Override
            public boolean isRestored() {
                return isRestored;
            }

            @Override
            public OperatorStateStore stateStore() {
                return stateStore;
            }
        };
    }

    public static interface Context {
        public String commitUser();

        @Nullable
        public OperatorMetricGroup metricGroup();

        public boolean streamingCheckpointEnabled();

        public boolean isRestored();

        public OperatorStateStore stateStore();
    }

    public static interface Factory<CommitT, GlobalCommitT>
    extends Serializable {
        public Committer<CommitT, GlobalCommitT> create(Context var1);
    }
}

