/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate.factory;

import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.factories.Factory;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.mergetree.compact.aggregate.FieldIgnoreRetractAgg;
import org.apache.paimon.types.DataType;

public interface FieldAggregatorFactory
extends Factory {
    public FieldAggregator create(DataType var1, CoreOptions var2, String var3);

    @Override
    public String identifier();

    public static FieldAggregator create(DataType fieldType, @Nullable String strAgg, boolean ignoreRetract, boolean isPrimaryKey, CoreOptions options, String field) {
        if (isPrimaryKey) {
            strAgg = "primary-key";
        } else if (strAgg == null) {
            strAgg = "last_non_null_value";
        }
        FieldAggregatorFactory fieldAggregatorFactory = FactoryUtil.discoverFactory(FieldAggregator.class.getClassLoader(), FieldAggregatorFactory.class, strAgg);
        if (fieldAggregatorFactory == null) {
            throw new RuntimeException(String.format("Use unsupported aggregation: %s or spell aggregate function incorrectly!", strAgg));
        }
        FieldAggregator fieldAggregator = fieldAggregatorFactory.create(fieldType, options, field);
        if (ignoreRetract) {
            fieldAggregator = new FieldIgnoreRetractAgg(fieldAggregator);
        }
        return fieldAggregator;
    }
}

