/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.partition.PartitionExpireStrategy;
import org.apache.paimon.partition.PartitionValuesTimeExpireStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionExpire {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionExpire.class);
    private static final String DELIMITER = ",";
    private final Duration expirationTime;
    private final Duration checkInterval;
    private final FileStoreScan scan;
    private final FileStoreCommit commit;
    private final MetastoreClient metastoreClient;
    private LocalDateTime lastCheck;
    private final PartitionExpireStrategy strategy;
    private final boolean endInputCheckPartitionExpire;
    private int maxExpireNum;

    public PartitionExpire(Duration expirationTime, Duration checkInterval, PartitionExpireStrategy strategy, FileStoreScan scan, FileStoreCommit commit, @Nullable MetastoreClient metastoreClient, boolean endInputCheckPartitionExpire, int maxExpireNum) {
        this.expirationTime = expirationTime;
        this.checkInterval = checkInterval;
        this.strategy = strategy;
        this.scan = scan;
        this.commit = commit;
        this.metastoreClient = metastoreClient;
        this.lastCheck = LocalDateTime.now();
        this.endInputCheckPartitionExpire = endInputCheckPartitionExpire;
        this.maxExpireNum = maxExpireNum;
    }

    public PartitionExpire(Duration expirationTime, Duration checkInterval, PartitionExpireStrategy strategy, FileStoreScan scan, FileStoreCommit commit, @Nullable MetastoreClient metastoreClient, int maxExpireNum) {
        this(expirationTime, checkInterval, strategy, scan, commit, metastoreClient, false, maxExpireNum);
    }

    public PartitionExpire withLock(Lock lock) {
        this.commit.withLock(lock);
        return this;
    }

    public PartitionExpire withMaxExpireNum(int maxExpireNum) {
        this.maxExpireNum = maxExpireNum;
        return this;
    }

    public List<Map<String, String>> expire(long commitIdentifier) {
        return this.expire(LocalDateTime.now(), commitIdentifier);
    }

    public boolean isValueExpiration() {
        return this.strategy instanceof PartitionValuesTimeExpireStrategy;
    }

    public boolean isValueAllExpired(Collection<BinaryRow> partitions) {
        PartitionValuesTimeExpireStrategy valuesStrategy = (PartitionValuesTimeExpireStrategy)this.strategy;
        LocalDateTime expireDateTime = LocalDateTime.now().minus(this.expirationTime);
        for (BinaryRow partition : partitions) {
            if (valuesStrategy.isExpired(expireDateTime, partition)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    void setLastCheck(LocalDateTime time) {
        this.lastCheck = time;
    }

    @VisibleForTesting
    List<Map<String, String>> expire(LocalDateTime now, long commitIdentifier) {
        if (this.checkInterval.isZero() || now.isAfter(this.lastCheck.plus(this.checkInterval)) || this.endInputCheckPartitionExpire && Long.MAX_VALUE == commitIdentifier) {
            List<Map<String, String>> expired = this.doExpire(now.minus(this.expirationTime), commitIdentifier);
            this.lastCheck = now;
            return expired;
        }
        return null;
    }

    private List<Map<String, String>> doExpire(LocalDateTime expireDateTime, long commitIdentifier) {
        List<PartitionEntry> partitionEntries = this.strategy.selectExpiredPartitions(this.scan, expireDateTime);
        ArrayList<List<String>> expiredPartValues = new ArrayList<List<String>>(partitionEntries.size());
        for (PartitionEntry partition : partitionEntries) {
            Object[] array = this.strategy.convertPartition(partition.partition());
            expiredPartValues.add(this.strategy.toPartitionValue(array));
        }
        List<Map<String, String>> expired = new ArrayList<Map<String, String>>();
        if (!expiredPartValues.isEmpty()) {
            expired = this.convertToPartitionString(expiredPartValues);
            LOG.info("Expire Partitions: {}", expired);
            if (this.metastoreClient != null) {
                this.deleteMetastorePartitions(expired);
            }
            this.commit.dropPartitions(expired, commitIdentifier);
        }
        return expired;
    }

    private void deleteMetastorePartitions(List<Map<String, String>> partitions) {
        if (this.metastoreClient != null && partitions.size() > 0) {
            try {
                this.metastoreClient.dropPartitions(partitions.stream().map(LinkedHashMap::new).collect(Collectors.toList()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<Map<String, String>> convertToPartitionString(List<List<String>> expiredPartValues) {
        return expiredPartValues.stream().map(values -> String.join((CharSequence)DELIMITER, values)).sorted().map(s -> s.split(DELIMITER)).map(this.strategy::toPartitionString).limit(Math.min(expiredPartValues.size(), this.maxExpireNum)).collect(Collectors.toList());
    }
}

