/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.rest.RESTUtil;
import org.apache.paimon.rest.auth.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthSession {
    static final int TOKEN_REFRESH_NUM_RETRIES = 5;
    static final long MIN_REFRESH_WAIT_MILLIS = 10L;
    static final long MAX_REFRESH_WINDOW_MILLIS = 300000L;
    private static final Logger log = LoggerFactory.getLogger(AuthSession.class);
    private final CredentialsProvider credentialsProvider;
    private volatile Map<String, String> headers;

    public AuthSession(Map<String, String> headers, CredentialsProvider credentialsProvider) {
        this.headers = headers;
        this.credentialsProvider = credentialsProvider;
    }

    public static AuthSession fromRefreshCredentialsProvider(ScheduledExecutorService executor, Map<String, String> headers, CredentialsProvider credentialsProvider) {
        boolean refreshSuccessful;
        AuthSession session = new AuthSession(headers, credentialsProvider);
        long startTimeMillis = System.currentTimeMillis();
        Optional<Long> expiresAtMillisOpt = credentialsProvider.expiresAtMillis();
        if (expiresAtMillisOpt.isPresent() && expiresAtMillisOpt.get() <= startTimeMillis && (refreshSuccessful = session.refresh().booleanValue())) {
            expiresAtMillisOpt = session.credentialsProvider.expiresAtMillis();
        }
        if (null != executor && expiresAtMillisOpt.isPresent()) {
            AuthSession.scheduleTokenRefresh(executor, session, expiresAtMillisOpt.get());
        }
        return session;
    }

    public Map<String, String> getHeaders() {
        if (this.credentialsProvider.keepRefreshed() && this.credentialsProvider.willSoonExpire()) {
            this.refresh();
        }
        return this.headers;
    }

    public Boolean refresh() {
        if (this.credentialsProvider.supportRefresh() && this.credentialsProvider.keepRefreshed() && this.credentialsProvider.expiresInMills().isPresent()) {
            boolean isSuccessful = this.credentialsProvider.refresh();
            if (isSuccessful) {
                Map<String, String> currentHeaders = this.headers;
                this.headers = RESTUtil.merge(currentHeaders, this.credentialsProvider.authHeader());
            }
            return isSuccessful;
        }
        return false;
    }

    @VisibleForTesting
    static void scheduleTokenRefresh(ScheduledExecutorService executor, AuthSession session, long expiresAtMillis) {
        AuthSession.scheduleTokenRefresh(executor, session, expiresAtMillis, 0);
    }

    @VisibleForTesting
    static long getTimeToWaitByExpiresInMills(long expiresInMillis) {
        long refreshWindowMillis = Math.min(expiresInMillis, 300000L);
        long waitIntervalMillis = expiresInMillis - refreshWindowMillis;
        return Math.max(waitIntervalMillis, 10L);
    }

    private static void scheduleTokenRefresh(ScheduledExecutorService executor, AuthSession session, long expiresAtMillis, int retryTimes) {
        if (retryTimes < 5) {
            long expiresInMillis = expiresAtMillis - System.currentTimeMillis();
            long timeToWait = AuthSession.getTimeToWaitByExpiresInMills(expiresInMillis);
            executor.schedule(() -> {
                long refreshStartTime = System.currentTimeMillis();
                boolean isSuccessful = session.refresh();
                if (isSuccessful) {
                    AuthSession.scheduleTokenRefresh(executor, session, refreshStartTime + session.credentialsProvider.expiresInMills().get(), 0);
                } else {
                    AuthSession.scheduleTokenRefresh(executor, session, expiresAtMillis, retryTimes + 1);
                }
            }, timeToWait, TimeUnit.MILLISECONDS);
        } else {
            log.warn("Failed to refresh token after {} retries.", (Object)5);
        }
    }
}

