/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.shade.guava30.com.google.common.base.MoreObjects;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.tag.TagPeriodHandler;
import org.apache.paimon.tag.TagTimeExtractor;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagAutoCreation {
    private static final Logger LOG = LoggerFactory.getLogger(TagAutoCreation.class);
    private final SnapshotManager snapshotManager;
    private final TagManager tagManager;
    private final TagDeletion tagDeletion;
    private final TagTimeExtractor timeExtractor;
    private final TagPeriodHandler periodHandler;
    private final Duration delay;
    @Nullable
    private final Integer numRetainedMax;
    @Nullable
    private final Duration defaultTimeRetained;
    private final List<TagCallback> callbacks;
    private final Duration idlenessTimeout;
    private final boolean automaticCompletion;
    private LocalDateTime nextTag;
    private long nextSnapshot;

    private TagAutoCreation(SnapshotManager snapshotManager, TagManager tagManager, TagDeletion tagDeletion, TagTimeExtractor timeExtractor, TagPeriodHandler periodHandler, Duration delay, @Nullable Integer numRetainedMax, @Nullable Duration defaultTimeRetained, Duration idlenessTimeout, boolean automaticCompletion, List<TagCallback> callbacks) {
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.tagDeletion = tagDeletion;
        this.timeExtractor = timeExtractor;
        this.periodHandler = periodHandler;
        this.delay = delay;
        this.numRetainedMax = numRetainedMax;
        this.defaultTimeRetained = defaultTimeRetained;
        this.callbacks = callbacks;
        this.idlenessTimeout = idlenessTimeout;
        this.automaticCompletion = automaticCompletion;
        this.periodHandler.validateDelay(delay);
        SortedMap<Snapshot, List<String>> tags = tagManager.tags(periodHandler::isAutoTag);
        if (tags.isEmpty()) {
            this.nextSnapshot = MoreObjects.firstNonNull(snapshotManager.earliestSnapshotId(), 1L);
        } else {
            Snapshot lastTag = tags.lastKey();
            this.nextSnapshot = lastTag.id() + 1L;
            String tagName = TagAutoCreation.checkAndGetOneAutoTag((List)tags.get(lastTag));
            LocalDateTime time = periodHandler.tagToTime(tagName);
            this.nextTag = periodHandler.nextTagTime(time);
        }
    }

    public boolean forceCreatingSnapshot() {
        if (this.timeExtractor instanceof TagTimeExtractor.WatermarkExtractor && this.idlenessTimeout != null) {
            Snapshot latestSnapshot = this.snapshotManager.latestSnapshot();
            if (latestSnapshot == null) {
                return false;
            }
            Long watermark = latestSnapshot.watermark();
            if (watermark == null) {
                return false;
            }
            LocalDateTime snapshotTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(watermark), ZoneId.systemDefault());
            return this.isAfterOrEqual(LocalDateTime.now().minus(this.idlenessTimeout), snapshotTime);
        }
        if (this.timeExtractor instanceof TagTimeExtractor.ProcessTimeExtractor) {
            return this.nextTag == null || this.isAfterOrEqual(LocalDateTime.now().minus(this.delay), this.periodHandler.nextTagTime(this.nextTag));
        }
        return false;
    }

    public void run() {
        while (true) {
            if (this.snapshotManager.snapshotExists(this.nextSnapshot)) {
                this.tryToCreateTags(this.snapshotManager.snapshot(this.nextSnapshot));
                ++this.nextSnapshot;
                continue;
            }
            Long earliest = this.snapshotManager.earliestSnapshotId();
            if (earliest == null || earliest <= this.nextSnapshot) break;
            this.nextSnapshot = earliest;
        }
    }

    private void tryToCreateTags(Snapshot snapshot) {
        Optional<LocalDateTime> timeOptional = this.timeExtractor.extract(snapshot.timeMillis(), snapshot.watermark());
        LOG.info("Starting to create a tag for snapshot {}.", (Object)snapshot.id());
        if (!timeOptional.isPresent()) {
            return;
        }
        LocalDateTime time = timeOptional.get();
        LOG.info("The time of snapshot {} is {}.", (Object)snapshot.id(), (Object)time);
        LOG.info("The next tag time is {}.", (Object)this.nextTag);
        if (this.nextTag == null || this.isAfterOrEqual(time.minus(this.delay), this.periodHandler.nextTagTime(this.nextTag))) {
            LocalDateTime thisTag = this.periodHandler.normalizeToPreviousTag(time);
            LOG.info("Create tag for snapshot {} with time {}.", (Object)snapshot.id(), (Object)thisTag);
            if (this.automaticCompletion && this.nextTag != null) {
                thisTag = this.nextTag;
            }
            String tagName = this.periodHandler.timeToTag(thisTag);
            LOG.info("The tag name is {}.", (Object)tagName);
            if (!this.tagManager.tagExists(tagName)) {
                this.tagManager.createTag(snapshot, tagName, this.defaultTimeRetained, this.callbacks);
            }
            this.nextTag = this.periodHandler.nextTagTime(thisTag);
            LOG.info("The next tag time after this is {}.", (Object)this.nextTag);
            if (this.numRetainedMax != null) {
                SortedMap<Snapshot, List<String>> tags = this.tagManager.tags(this.periodHandler::isAutoTag);
                if (tags.size() > this.numRetainedMax) {
                    int toDelete = tags.size() - this.numRetainedMax;
                    int i = 0;
                    for (List<String> tag : tags.values()) {
                        LOG.info("Delete tag {}, because the number of auto-created tags reached numRetainedMax of {}.", (Object)tagName, (Object)this.numRetainedMax);
                        this.tagManager.deleteTag(TagAutoCreation.checkAndGetOneAutoTag(tag), this.tagDeletion, this.snapshotManager, this.callbacks);
                        if (++i != toDelete) continue;
                        break;
                    }
                }
            }
        }
    }

    private boolean isAfterOrEqual(LocalDateTime t1, LocalDateTime t2) {
        return t1.isAfter(t2) || t1.isEqual(t2);
    }

    public static String checkAndGetOneAutoTag(List<String> autoTags) {
        Preconditions.checkState(autoTags.size() == 1, "There are more than 1 auto-created tags of the same snapshot: %s. This is unexpected.", String.join((CharSequence)",", autoTags));
        return autoTags.get(0);
    }

    @Nullable
    public static TagAutoCreation create(CoreOptions options, SnapshotManager snapshotManager, TagManager tagManager, TagDeletion tagDeletion, List<TagCallback> callbacks) {
        TagTimeExtractor extractor = TagTimeExtractor.createForAutoTag(options);
        if (extractor == null) {
            return null;
        }
        return new TagAutoCreation(snapshotManager, tagManager, tagDeletion, extractor, TagPeriodHandler.create(options), options.tagCreationDelay(), options.tagNumRetainedMax(), options.tagDefaultTimeRetained(), options.snapshotWatermarkIdleTimeout(), options.tagAutomaticCompletion(), callbacks);
    }
}

