/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLock;
import org.apache.paimon.catalog.CatalogLockContext;
import org.apache.paimon.catalog.Database;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemCatalog
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemCatalog.class);
    private final Path warehouse;

    public FileSystemCatalog(FileIO fileIO, Path warehouse) {
        super(fileIO);
        this.warehouse = warehouse;
    }

    public FileSystemCatalog(FileIO fileIO, Path warehouse, Options options) {
        super(fileIO, options);
        this.warehouse = warehouse;
    }

    @Override
    public List<String> listDatabases() {
        return FileSystemCatalog.uncheck(() -> this.listDatabasesInFileSystem(this.warehouse));
    }

    @Override
    protected void createDatabaseImpl(String name, Map<String, String> properties) {
        Path databasePath;
        if (properties.containsKey("location")) {
            throw new IllegalArgumentException("Cannot specify location for a database when using fileSystem catalog.");
        }
        if (!properties.isEmpty()) {
            LOG.warn("Currently filesystem catalog can't store database properties, discard properties: {}", properties);
        }
        if (!FileSystemCatalog.uncheck(() -> this.lambda$createDatabaseImpl$1(databasePath = this.newDatabasePath(name))).booleanValue()) {
            throw new RuntimeException(String.format("Create database location failed, database: %s, location: %s", name, databasePath));
        }
    }

    @Override
    public Database getDatabaseImpl(String name) throws Catalog.DatabaseNotExistException {
        if (!FileSystemCatalog.uncheck(() -> this.fileIO.exists(this.newDatabasePath(name))).booleanValue()) {
            throw new Catalog.DatabaseNotExistException(name);
        }
        return Database.of(name);
    }

    @Override
    protected void dropDatabaseImpl(String name) {
        FileSystemCatalog.uncheck(() -> this.fileIO.delete(this.newDatabasePath(name), true));
    }

    @Override
    protected void alterDatabaseImpl(String name, List<PropertyChange> changes) {
        throw new UnsupportedOperationException("Alter database is not supported.");
    }

    @Override
    protected List<String> listTablesImpl(String databaseName) {
        return FileSystemCatalog.uncheck(() -> this.listTablesInFileSystem(this.newDatabasePath(databaseName)));
    }

    @Override
    public TableSchema getDataTableSchema(Identifier identifier) throws Catalog.TableNotExistException {
        return this.tableSchemaInFileSystem(this.getTableLocation(identifier), identifier.getBranchNameOrDefault()).orElseThrow(() -> new Catalog.TableNotExistException(identifier));
    }

    @Override
    protected void dropTableImpl(Identifier identifier) {
        Path path = this.getTableLocation(identifier);
        FileSystemCatalog.uncheck(() -> this.fileIO.delete(path, true));
    }

    @Override
    public void createTableImpl(Identifier identifier, Schema schema) {
        FileSystemCatalog.uncheck(() -> this.schemaManager(identifier).createTable(schema));
    }

    private SchemaManager schemaManager(Identifier identifier) {
        Path path = this.getTableLocation(identifier);
        CatalogLock catalogLock = this.lockFactory().map(fac -> fac.createLock(this.assertGetLockContext())).orElse(null);
        return new SchemaManager(this.fileIO, path, identifier.getBranchNameOrDefault()).withLock(catalogLock == null ? null : Lock.fromCatalog(catalogLock, identifier));
    }

    private CatalogLockContext assertGetLockContext() {
        return this.lockContext().orElseThrow(() -> new RuntimeException("No lock context when lock is enabled."));
    }

    @Override
    public void renameTableImpl(Identifier fromTable, Identifier toTable) {
        Path fromPath = this.getTableLocation(fromTable);
        Path toPath = this.getTableLocation(toTable);
        FileSystemCatalog.uncheck(() -> this.fileIO.rename(fromPath, toPath));
    }

    @Override
    protected void alterTableImpl(Identifier identifier, List<SchemaChange> changes) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        this.schemaManager(identifier).commitChanges(changes);
    }

    protected static <T> T uncheck(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public String warehouse() {
        return this.warehouse.toString();
    }

    @Override
    public boolean caseSensitive() {
        return this.catalogOptions.getOptional(CatalogOptions.CASE_SENSITIVE).orElse(true);
    }

    private /* synthetic */ Boolean lambda$createDatabaseImpl$1(Path databasePath) throws Exception {
        return this.fileIO.mkdirs(databasePath);
    }
}

