/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.StringUtils;

public class RollbackToProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "rollback_to";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="tag", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="snapshot_id", type=@DataTypeHint(value="BIGINT"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, String tagName, Long snapshotId) throws Catalog.TableNotExistException {
        Table table = this.catalog.getTable(Identifier.fromString(tableId));
        if (!StringUtils.isNullOrWhitespaceOnly(tagName)) {
            table.rollbackTo(tagName);
        } else {
            table.rollbackTo(snapshotId);
        }
        return new String[]{"Success"};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

