/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.IncrementalStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;

public class IncrementalTimeStampStartingScanner
extends AbstractStartingScanner {
    private final long startTimestamp;
    private final long endTimestamp;
    private final ScanMode scanMode;

    public IncrementalTimeStampStartingScanner(SnapshotManager snapshotManager, long startTimestamp, long endTimestamp, ScanMode scanMode) {
        super(snapshotManager);
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.scanMode = scanMode;
        Snapshot startingSnapshot = snapshotManager.earlierOrEqualTimeMills(startTimestamp);
        if (startingSnapshot != null) {
            this.startingSnapshotId = startingSnapshot.id();
        }
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader reader) {
        Snapshot earliestSnapshot = this.snapshotManager.snapshot(this.snapshotManager.earliestSnapshotId());
        Snapshot latestSnapshot = this.snapshotManager.latestSnapshot();
        if (this.startTimestamp > latestSnapshot.timeMillis() || this.endTimestamp < earliestSnapshot.timeMillis()) {
            return new StartingScanner.NoSnapshot();
        }
        Long startSnapshotId = this.startingSnapshotId == null || earliestSnapshot.timeMillis() > this.startTimestamp ? earliestSnapshot.id() - 1L : this.startingSnapshotId;
        Snapshot endSnapshot = this.snapshotManager.earlierOrEqualTimeMills(this.endTimestamp);
        Long endSnapshotId = endSnapshot == null ? latestSnapshot.id() : endSnapshot.id();
        IncrementalStartingScanner incrementalStartingScanner = new IncrementalStartingScanner(this.snapshotManager, startSnapshotId, endSnapshotId, this.scanMode);
        return incrementalStartingScanner.scan(reader);
    }
}

