/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsIndexFile;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.Preconditions;

public class DeletionVectorIndexFileWriter {
    private final PathFactory indexPathFactory;
    private final FileIO fileIO;
    private final long targetSizeInBytes;

    public DeletionVectorIndexFileWriter(FileIO fileIO, PathFactory pathFactory, MemorySize targetSizePerIndexFile) {
        this.indexPathFactory = pathFactory;
        this.fileIO = fileIO;
        this.targetSizeInBytes = targetSizePerIndexFile.getBytes();
    }

    public List<IndexFileMeta> write(Map<String, DeletionVector> input) throws IOException {
        if (input.isEmpty()) {
            return this.emptyIndexFile();
        }
        ArrayList<IndexFileMeta> result = new ArrayList<IndexFileMeta>();
        Iterator<Map.Entry<String, DeletionVector>> iterator2 = input.entrySet().iterator();
        while (iterator2.hasNext()) {
            result.add(this.tryWriter(iterator2));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexFileMeta tryWriter(Iterator<Map.Entry<String, DeletionVector>> iterator2) throws IOException {
        try (SingleIndexFileWriter writer = new SingleIndexFileWriter();){
            while (iterator2.hasNext()) {
                Map.Entry<String, DeletionVector> entry = iterator2.next();
                writer.write(entry.getKey(), entry.getValue());
                if (writer.writtenSizeInBytes() <= this.targetSizeInBytes) continue;
                break;
            }
        }
        return writer.writtenIndexFile();
    }

    private List<IndexFileMeta> emptyIndexFile() throws IOException {
        SingleIndexFileWriter writer = new SingleIndexFileWriter();
        writer.close();
        return Collections.singletonList(writer.writtenIndexFile());
    }

    private class SingleIndexFileWriter
    implements Closeable {
        private final Path path;
        private final DataOutputStream dataOutputStream;
        private final LinkedHashMap<String, DeletionVectorMeta> dvMetas;

        private SingleIndexFileWriter() throws IOException {
            this.path = DeletionVectorIndexFileWriter.this.indexPathFactory.newPath();
            this.dataOutputStream = new DataOutputStream(DeletionVectorIndexFileWriter.this.fileIO.newOutputStream(this.path, true));
            this.dataOutputStream.writeByte(1);
            this.dvMetas = new LinkedHashMap();
        }

        private long writtenSizeInBytes() {
            return this.dataOutputStream.size();
        }

        private void write(String key, DeletionVector deletionVector) throws IOException {
            Preconditions.checkNotNull(this.dataOutputStream);
            byte[] data = deletionVector.serializeToBytes();
            int size = data.length;
            this.dvMetas.put(key, new DeletionVectorMeta(key, this.dataOutputStream.size(), size, deletionVector.getCardinality()));
            this.dataOutputStream.writeInt(size);
            this.dataOutputStream.write(data);
            this.dataOutputStream.writeInt(DeletionVectorsIndexFile.calculateChecksum(data));
        }

        public IndexFileMeta writtenIndexFile() {
            return new IndexFileMeta("DELETION_VECTORS", this.path.getName(), this.writtenSizeInBytes(), this.dvMetas.size(), this.dvMetas);
        }

        @Override
        public void close() throws IOException {
            this.dataOutputStream.close();
        }
    }
}

