/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.ClearConsumerAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class ClearConsumerActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "clear_consumers";
    private static final String INCLUDING_CONSUMERS = "including_consumers";
    private static final String EXCLUDING_CONSUMERS = "excluding_consumers";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        ClearConsumerAction action = new ClearConsumerAction(params.getRequired("database"), params.getRequired("table"), this.catalogConfigMap(params));
        if (params.has(INCLUDING_CONSUMERS)) {
            action.withIncludingConsumers(params.get(INCLUDING_CONSUMERS));
        }
        if (params.has(EXCLUDING_CONSUMERS)) {
            action.withExcludingConsumers(params.get(EXCLUDING_CONSUMERS));
        }
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"clear_consumers\" clear consumers with including consumers and excluding consumers.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  clear_consumers \\\n--warehouse <warehouse_path> \\\n--database <database_name> \\\n--table <table_name> \\\n[--including_consumers <including_pattern> --excluding_consumers <excluding_pattern>]");
        System.out.println();
        System.out.println("Note:");
        System.out.println("  use '' as placeholder for including_consumers if you want to clear all consumers except excludingConsumers in the table.");
        System.out.println();
    }
}

