/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.append.MultiTableUnawareAppendCompactionTask;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.action.MultiTablesSinkMode;
import org.apache.paimon.flink.compact.UnawareBucketCompactionTopoBuilder;
import org.apache.paimon.flink.sink.BucketsRowChannelComputer;
import org.apache.paimon.flink.sink.CombinedTableCompactorSink;
import org.apache.paimon.flink.sink.CompactorSinkBuilder;
import org.apache.paimon.flink.sink.FlinkStreamPartitioner;
import org.apache.paimon.flink.source.CombinedTableCompactorSourceBuilder;
import org.apache.paimon.flink.source.CompactorSourceBuilder;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactDatabaseAction
extends ActionBase {
    private static final Logger LOG = LoggerFactory.getLogger(CompactDatabaseAction.class);
    private Pattern includingPattern = Pattern.compile(".*");
    @Nullable
    private Pattern excludingPattern;
    private Pattern databasePattern = Pattern.compile(".*");
    private MultiTablesSinkMode databaseCompactMode = MultiTablesSinkMode.DIVIDED;
    private final Map<String, FileStoreTable> tableMap = new HashMap<String, FileStoreTable>();
    private Options tableOptions = new Options();
    @Nullable
    private Duration partitionIdleTime = null;
    private Boolean fullCompaction;
    private boolean isStreaming;

    public CompactDatabaseAction(Map<String, String> catalogConfig) {
        super(catalogConfig);
    }

    public CompactDatabaseAction includingDatabases(@Nullable String includingDatabases) {
        if (includingDatabases != null) {
            this.databasePattern = Pattern.compile(includingDatabases);
        }
        return this;
    }

    public CompactDatabaseAction includingTables(@Nullable String includingTables) {
        if (includingTables != null) {
            this.includingPattern = Pattern.compile(includingTables);
        }
        return this;
    }

    public CompactDatabaseAction excludingTables(@Nullable String excludingTables) {
        this.excludingPattern = excludingTables == null ? null : Pattern.compile(excludingTables);
        return this;
    }

    public CompactDatabaseAction withDatabaseCompactMode(@Nullable String mode) {
        this.databaseCompactMode = MultiTablesSinkMode.fromString(mode);
        return this;
    }

    public CompactDatabaseAction withTableOptions(Map<String, String> tableOptions) {
        this.tableOptions = Options.fromMap(tableOptions);
        return this;
    }

    public CompactDatabaseAction withPartitionIdleTime(@Nullable Duration partitionIdleTime) {
        this.partitionIdleTime = partitionIdleTime;
        return this;
    }

    public CompactDatabaseAction withFullCompaction(boolean fullCompaction) {
        this.fullCompaction = fullCompaction;
        return this;
    }

    private boolean shouldCompactionTable(String paimonFullTableName) {
        boolean shouldCompaction = this.includingPattern.matcher(paimonFullTableName).matches();
        if (this.excludingPattern != null) {
            boolean bl = shouldCompaction = shouldCompaction && !this.excludingPattern.matcher(paimonFullTableName).matches();
        }
        if (!shouldCompaction) {
            LOG.debug("Source table '{}' is excluded.", (Object)paimonFullTableName);
        }
        return shouldCompaction;
    }

    @Override
    public void build() {
        ReadableConfig conf = this.env.getConfiguration();
        boolean bl = this.isStreaming = conf.get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
        if (this.fullCompaction == null) {
            this.fullCompaction = !this.isStreaming;
        }
        if (this.databaseCompactMode == MultiTablesSinkMode.DIVIDED) {
            this.buildForDividedMode();
        } else {
            this.buildForCombinedMode();
        }
    }

    private void buildForDividedMode() {
        try {
            List<String> databases = this.catalog.listDatabases();
            for (String databaseName : databases) {
                Matcher databaseMatcher = this.databasePattern.matcher(databaseName);
                if (!databaseMatcher.matches()) continue;
                List<String> tables = this.catalog.listTables(databaseName);
                for (String tableName : tables) {
                    String fullTableName = String.format("%s.%s", databaseName, tableName);
                    if (this.shouldCompactionTable(fullTableName)) {
                        Table table = this.catalog.getTable(Identifier.create(databaseName, tableName));
                        if (!(table instanceof FileStoreTable)) {
                            LOG.error(String.format("Only FileStoreTable supports compact action. The table type is '%s'.", table.getClass().getName()));
                            continue;
                        }
                        HashMap<String, String> dynamicOptions = new HashMap<String, String>(this.tableOptions.toMap());
                        dynamicOptions.put(CoreOptions.WRITE_ONLY.key(), "false");
                        FileStoreTable fileStoreTable = (FileStoreTable)table.copy(dynamicOptions);
                        this.tableMap.put(fullTableName, fileStoreTable);
                        continue;
                    }
                    LOG.debug("The table {} is excluded.", (Object)fullTableName);
                }
            }
        }
        catch (Catalog.DatabaseNotExistException | Catalog.TableNotExistException e) {
            throw new RuntimeException(e);
        }
        Preconditions.checkState(!this.tableMap.isEmpty(), "no tables to be compacted. possible cause is that there are no tables detected after pattern matching");
        block7: for (Map.Entry<String, FileStoreTable> entry : this.tableMap.entrySet()) {
            FileStoreTable fileStoreTable = entry.getValue();
            switch (fileStoreTable.bucketMode()) {
                case BUCKET_UNAWARE: {
                    this.buildForUnawareBucketCompaction(this.env, entry.getKey(), fileStoreTable);
                    continue block7;
                }
            }
            this.buildForTraditionalCompaction(this.env, entry.getKey(), fileStoreTable);
        }
    }

    private void buildForCombinedMode() {
        CombinedTableCompactorSourceBuilder sourceBuilder = new CombinedTableCompactorSourceBuilder(this.catalogLoader(), this.databasePattern, this.includingPattern, this.excludingPattern, this.tableOptions.get(CoreOptions.CONTINUOUS_DISCOVERY_INTERVAL).toMillis()).withPartitionIdleTime(this.partitionIdleTime);
        sourceBuilder.withTableOptions(this.tableOptions.toMap());
        Integer parallelism = this.tableOptions.get(FlinkConnectorOptions.SINK_PARALLELISM) == null ? Integer.valueOf(this.env.getParallelism()) : this.tableOptions.get(FlinkConnectorOptions.SINK_PARALLELISM);
        DataStream<RowData> awareBucketTableSource = FlinkStreamPartitioner.partition(sourceBuilder.withEnv(this.env).withContinuousMode(this.isStreaming).buildAwareBucketTableSource(), new BucketsRowChannelComputer(), parallelism);
        DataStream<MultiTableUnawareAppendCompactionTask> unawareBucketTableSource = FlinkStreamPartitioner.rebalance(sourceBuilder.withEnv(this.env).withContinuousMode(this.isStreaming).buildForUnawareBucketsTableSource(), parallelism);
        new CombinedTableCompactorSink(this.catalogLoader(), this.tableOptions, this.fullCompaction).sinkFrom(awareBucketTableSource, unawareBucketTableSource);
    }

    private void buildForTraditionalCompaction(StreamExecutionEnvironment env, String fullName, FileStoreTable table) {
        Preconditions.checkArgument(this.fullCompaction == false || !this.isStreaming, "The full compact strategy is only supported in batch mode. Please add -Dexecution.runtime-mode=BATCH.");
        if (this.isStreaming) {
            HashMap<String, String> dynamicOptions = new HashMap<String, String>(){
                {
                    this.put(CoreOptions.NUM_SORTED_RUNS_STOP_TRIGGER.key(), "2147483647");
                    this.put(CoreOptions.SORT_SPILL_THRESHOLD.key(), "10");
                    this.put(CoreOptions.LOOKUP_WAIT.key(), "false");
                }
            };
            table = table.copy(dynamicOptions);
        }
        CompactorSourceBuilder sourceBuilder = new CompactorSourceBuilder(fullName, (FileStoreTable)table).withPartitionIdleTime(this.partitionIdleTime);
        CompactorSinkBuilder sinkBuilder = new CompactorSinkBuilder((FileStoreTable)table, this.fullCompaction);
        DataStreamSource<RowData> source2 = sourceBuilder.withEnv(env).withContinuousMode(this.isStreaming).build();
        sinkBuilder.withInput((DataStream<RowData>)source2).build();
    }

    private void buildForUnawareBucketCompaction(StreamExecutionEnvironment env, String fullName, FileStoreTable table) {
        UnawareBucketCompactionTopoBuilder unawareBucketCompactionTopoBuilder = new UnawareBucketCompactionTopoBuilder(env, fullName, table);
        unawareBucketCompactionTopoBuilder.withContinuousMode(this.isStreaming);
        unawareBucketCompactionTopoBuilder.withPartitionIdleTime(this.partitionIdleTime);
        unawareBucketCompactionTopoBuilder.build();
    }

    @Override
    public void run() throws Exception {
        this.build();
        this.execute("Compact database job");
    }
}

