/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.partition.PartitionExpireStrategy;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.TimeUtils;

public class ExpirePartitionsAction
extends TableActionBase {
    private final PartitionExpire partitionExpire;

    public ExpirePartitionsAction(String databaseName, String tableName, Map<String, String> catalogConfig, String expirationTime, String timestampFormatter, String timestampPattern, String expireStrategy) {
        super(databaseName, tableName, catalogConfig);
        if (!(this.table instanceof FileStoreTable)) {
            throw new UnsupportedOperationException(String.format("Only FileStoreTable supports expire_partitions action. The table type is '%s'.", this.table.getClass().getName()));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CoreOptions.PARTITION_EXPIRATION_STRATEGY.key(), expireStrategy);
        map.put(CoreOptions.PARTITION_TIMESTAMP_FORMATTER.key(), timestampFormatter);
        map.put(CoreOptions.PARTITION_TIMESTAMP_PATTERN.key(), timestampPattern);
        FileStoreTable fileStoreTable = (FileStoreTable)this.table;
        FileStore<?> fileStore = fileStoreTable.store();
        this.partitionExpire = fileStore.newPartitionExpire("", fileStoreTable, TimeUtils.parseDuration(expirationTime), Duration.ofMillis(0L), PartitionExpireStrategy.createPartitionExpireStrategy(CoreOptions.fromMap(map), fileStore.partitionType()));
    }

    @Override
    public void run() throws Exception {
        this.partitionExpire.expire(Long.MAX_VALUE);
    }
}

