/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeJsonParser;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializableSupplier;
import org.apache.paimon.utils.StringUtils;

public interface Expression
extends Serializable {
    public String fieldReference();

    public DataType outputType();

    public String eval(String var1);

    public static Expression create(Map<String, DataType> typeMapping, boolean caseSensitive, String exprName, String ... args2) {
        ExpressionCreator function = ExpressionFunction.creator(exprName.toLowerCase());
        if (function == null) {
            throw new UnsupportedOperationException(String.format("Unsupported expression: %s. Supported expressions are: %s", exprName, String.join((CharSequence)",", ExpressionFunction.EXPRESSION_FUNCTIONS.keySet())));
        }
        return function.create(typeMapping, caseSensitive, args2);
    }

    public static Expression substring(String fieldReference, String ... literals) {
        Integer endExclusive;
        int beginInclusive;
        Preconditions.checkArgument(literals.length == 1 || literals.length == 2, String.format("'substring' expression supports one or two arguments, but found '%s'.", literals.length));
        try {
            beginInclusive = Integer.parseInt(literals[0]);
            endExclusive = literals.length == 1 ? null : Integer.valueOf(Integer.parseInt(literals[1]));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("The index arguments '%s' contain non integer value.", Arrays.toString(literals)), e);
        }
        Preconditions.checkArgument(beginInclusive >= 0, "begin index argument (%s) of 'substring' must be >= 0.", beginInclusive);
        Preconditions.checkArgument(endExclusive == null || endExclusive > beginInclusive, "end index (%s) must be larger than begin index (%s).", endExclusive, beginInclusive);
        return new Substring(fieldReference, beginInclusive, endExclusive);
    }

    public static Expression truncate(String fieldReference, DataType fieldType, String ... literals) {
        Preconditions.checkArgument(literals.length == 1, String.format("'truncate' expression supports one argument, but found '%s'.", literals.length));
        return new TruncateComputer(fieldReference, fieldType, literals[0]);
    }

    public static Expression cast(String ... literals) {
        Preconditions.checkArgument(literals.length == 1 || literals.length == 2, String.format("'cast' expression supports one or two arguments, but found '%s'.", literals.length));
        DataType dataType = DataTypes.STRING();
        if (literals.length == 2) {
            dataType = DataTypeJsonParser.parseAtomicTypeSQLString(literals[1]);
        }
        return new CastExpression(literals[0], dataType);
    }

    public static final class NowExpression
    implements Expression {
        @Override
        public String fieldReference() {
            return null;
        }

        @Override
        public DataType outputType() {
            return DataTypes.TIMESTAMP(3);
        }

        @Override
        public String eval(String input) {
            return DateTimeUtils.formatLocalDateTime(LocalDateTime.now(), 3);
        }
    }

    public static final class CastExpression
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String value;
        private final DataType dataType;

        private CastExpression(String value, DataType dataType) {
            this.value = value;
            this.dataType = dataType;
        }

        @Override
        public String fieldReference() {
            return null;
        }

        @Override
        public DataType outputType() {
            return this.dataType;
        }

        @Override
        public String eval(String input) {
            return this.value;
        }
    }

    public static final class TruncateComputer
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;
        private final DataType fieldType;
        private final int width;

        TruncateComputer(String fieldReference, DataType fieldType, String literal) {
            this.fieldReference = fieldReference;
            this.fieldType = fieldType;
            try {
                this.width = Integer.parseInt(literal);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Invalid width value for truncate function: %s, expected integer.", literal));
            }
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return this.fieldType;
        }

        @Override
        public String eval(String input) {
            switch (this.fieldType.getTypeRoot()) {
                case TINYINT: 
                case SMALLINT: {
                    return String.valueOf(this.truncateShort(this.width, Short.parseShort(input)));
                }
                case INTEGER: {
                    return String.valueOf(this.truncateInt(this.width, Integer.parseInt(input)));
                }
                case BIGINT: {
                    return String.valueOf(this.truncateLong(this.width, Long.parseLong(input)));
                }
                case DECIMAL: {
                    return this.truncateDecimal(BigInteger.valueOf(this.width), new BigDecimal(input)).toString();
                }
                case VARCHAR: 
                case CHAR: {
                    Preconditions.checkArgument(this.width <= input.length(), "Invalid width value for truncate function: %s, expected less than or equal to %s.", this.width, input.length());
                    return input.substring(0, this.width);
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported field type for truncate function: %s.", this.fieldType.getTypeRoot().toString()));
        }

        private short truncateShort(int width, short value) {
            return (short)(value - (value % width + width) % width);
        }

        private int truncateInt(int width, int value) {
            return value - (value % width + width) % width;
        }

        private long truncateLong(int width, long value) {
            return value - (value % (long)width + (long)width) % (long)width;
        }

        private BigDecimal truncateDecimal(BigInteger unscaledWidth, BigDecimal value) {
            BigDecimal remainder = new BigDecimal(value.unscaledValue().remainder(unscaledWidth).add(unscaledWidth).remainder(unscaledWidth), value.scale());
            return value.subtract(remainder);
        }
    }

    public static final class Substring
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;
        private final int beginInclusive;
        @Nullable
        private final Integer endExclusive;

        private Substring(String fieldReference, int beginInclusive, @Nullable Integer endExclusive) {
            this.fieldReference = fieldReference;
            this.beginInclusive = beginInclusive;
            this.endExclusive = endExclusive;
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return DataTypes.STRING();
        }

        @Override
        public String eval(String input) {
            try {
                if (this.endExclusive == null) {
                    return input.substring(this.beginInclusive);
                }
                return input.substring(this.beginInclusive, this.endExclusive);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new RuntimeException(String.format("Cannot get substring from '%s' because the indexes are out of range. Begin index: %s, end index: %s.", input, this.beginInclusive, this.endExclusive));
            }
        }
    }

    public static final class DateFormat
    extends TemporalExpressionBase<String> {
        private static final long serialVersionUID = 2L;
        private final String pattern;

        private DateFormat(String fieldReference, DataType fieldType, String pattern, @Nullable Integer precision) {
            super(fieldReference, fieldType, precision);
            this.pattern = pattern;
        }

        @Override
        public DataType outputType() {
            return DataTypes.STRING();
        }

        @Override
        protected Function<LocalDateTime, String> createConverter() {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.pattern);
            return localDateTime -> localDateTime.format(formatter);
        }

        private static DateFormat create(String fieldReference, DataType fieldType, String ... literals) {
            Preconditions.checkArgument(literals.length == 1 || literals.length == 2, "'date_format' supports 1 or 2 arguments, but found '%s'.", literals.length);
            return new DateFormat(fieldReference, fieldType, literals[0], literals.length == 1 ? null : Integer.valueOf(literals[1]));
        }
    }

    public static final class TemporalToIntConverter
    extends TemporalExpressionBase<Integer> {
        private static final long serialVersionUID = 1L;
        private final SerializableSupplier<Function<LocalDateTime, Integer>> converterSupplier;

        private TemporalToIntConverter(String fieldReference, DataType fieldType, @Nullable Integer precision, SerializableSupplier<Function<LocalDateTime, Integer>> converterSupplier) {
            super(fieldReference, fieldType, precision);
            this.converterSupplier = converterSupplier;
        }

        @Override
        protected Function<LocalDateTime, Integer> createConverter() {
            return (Function)this.converterSupplier.get();
        }

        private static TemporalToIntConverter create(String fieldReference, DataType fieldType, SerializableSupplier<Function<LocalDateTime, Integer>> converterSupplier, String ... literals) {
            Preconditions.checkArgument(literals.length == 0 || literals.length == 1, "TemporalToIntConverter supports 0 or 1 argument, but found '%s'.", literals.length);
            return new TemporalToIntConverter(fieldReference, fieldType, literals.length == 0 ? null : Integer.valueOf(literals[0]), converterSupplier);
        }
    }

    public static abstract class TemporalExpressionBase<T>
    implements Expression {
        private static final long serialVersionUID = 1L;
        private static final List<Integer> SUPPORTED_PRECISION = Arrays.asList(0, 3, 6, 9);
        private final String fieldReference;
        @Nullable
        private final Integer precision;
        private transient Function<LocalDateTime, T> converter;

        private TemporalExpressionBase(String fieldReference, DataType fieldType, @Nullable Integer precision) {
            this.fieldReference = fieldReference;
            if (fieldType.getTypeRoot().getFamilies().contains((Object)DataTypeFamily.INTEGER_NUMERIC) && precision == null) {
                precision = 0;
            }
            Preconditions.checkArgument(precision == null || SUPPORTED_PRECISION.contains(precision), "Unsupported precision of temporal function: %d. Supported precisions are: 0 (for epoch seconds), 3 (for epoch milliseconds), 6 (for epoch microseconds) and 9 (for epoch nanoseconds).", precision);
            this.precision = precision;
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return DataTypes.INT();
        }

        @Override
        public String eval(String input) {
            if (this.converter == null) {
                this.converter = this.createConverter();
            }
            T result = this.converter.apply(this.toLocalDateTime(input));
            return String.valueOf(result);
        }

        private LocalDateTime toLocalDateTime(String input) {
            if (this.precision == null) {
                return DateTimeUtils.toLocalDateTime(input, 9);
            }
            long numericValue = Long.parseLong(input);
            long milliseconds = 0L;
            int nanosOfMillisecond = 0;
            switch (this.precision) {
                case 0: {
                    milliseconds = numericValue * 1000L;
                    break;
                }
                case 3: {
                    milliseconds = numericValue;
                    break;
                }
                case 6: {
                    milliseconds = numericValue / 1000L;
                    nanosOfMillisecond = (int)(numericValue % 1000L * 1000L);
                    break;
                }
                case 9: {
                    milliseconds = numericValue / 1000000L;
                    nanosOfMillisecond = (int)(numericValue % 1000000L);
                }
            }
            return Timestamp.fromEpochMillis(milliseconds, nanosOfMillisecond).toLocalDateTime();
        }

        protected abstract Function<LocalDateTime, T> createConverter();
    }

    public static class ReferencedField {
        private final String field;
        private final DataType fieldType;
        private final String[] literals;

        private ReferencedField(String field, DataType fieldType, String[] literals) {
            this.field = field;
            this.fieldType = fieldType;
            this.literals = literals;
        }

        public static ReferencedField checkArgument(Map<String, DataType> typeMapping, boolean caseSensitive, String ... args2) {
            String referencedField = args2[0].trim();
            String[] literals = (String[])Arrays.stream(args2).skip(1L).map(String::trim).toArray(String[]::new);
            String referencedFieldCheckForm = StringUtils.toLowerCaseIfNeed(referencedField, caseSensitive);
            DataType fieldType = Preconditions.checkNotNull(typeMapping.get(referencedFieldCheckForm), String.format("Referenced field '%s' is not in given fields: %s.", referencedFieldCheckForm, typeMapping.keySet()));
            return new ReferencedField(referencedField, fieldType, literals);
        }

        public String field() {
            return this.field;
        }

        public DataType fieldType() {
            return this.fieldType;
        }

        public String[] literals() {
            return this.literals;
        }
    }

    @FunctionalInterface
    public static interface ExpressionCreator {
        public Expression create(Map<String, DataType> var1, boolean var2, String[] var3);
    }

    public static enum ExpressionFunction {
        YEAR((typeMapping, caseSensitive, args2) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args2);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), () -> LocalDateTime::getYear, referencedField.literals());
        }),
        MONTH((typeMapping, caseSensitive, args2) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args2);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), () -> LocalDateTime::getMonthValue, referencedField.literals());
        }),
        DAY((typeMapping, caseSensitive, args2) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args2);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), () -> LocalDateTime::getDayOfMonth, referencedField.literals());
        }),
        HOUR((typeMapping, caseSensitive, args2) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args2);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), () -> LocalDateTime::getHour, referencedField.literals());
        }),
        MINUTE((typeMapping, caseSensitive, args2) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args2);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), () -> LocalDateTime::getMinute, referencedField.literals());
        }),
        SECOND((typeMapping, caseSensitive, args2) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args2);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), () -> LocalDateTime::getSecond, referencedField.literals());
        }),
        DATE_FORMAT((typeMapping, caseSensitive, args2) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args2);
            return DateFormat.create(referencedField.field(), referencedField.fieldType(), referencedField.literals());
        }),
        SUBSTRING((typeMapping, caseSensitive, args2) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args2);
            return Expression.substring(referencedField.field(), referencedField.literals());
        }),
        TRUNCATE((typeMapping, caseSensitive, args2) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args2);
            return Expression.truncate(referencedField.field(), referencedField.fieldType(), referencedField.literals());
        }),
        CAST((typeMapping, caseSensitive, args2) -> Expression.cast(args2)),
        NOW((typeMapping, caseSensitive, args2) -> new NowExpression());

        public final ExpressionCreator creator;
        private static final Map<String, ExpressionCreator> EXPRESSION_FUNCTIONS;

        private ExpressionFunction(ExpressionCreator creator) {
            this.creator = creator;
        }

        public ExpressionCreator getCreator() {
            return this.creator;
        }

        public static ExpressionCreator creator(String exprName) {
            return EXPRESSION_FUNCTIONS.get(exprName.toLowerCase());
        }

        static {
            EXPRESSION_FUNCTIONS = Arrays.stream(ExpressionFunction.values()).collect(Collectors.toMap(value -> value.name().toLowerCase(), ExpressionFunction::getCreator));
        }
    }
}

