/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.api.connector.source.SupportsHandleExecutionAttemptSourceEvent;
import org.apache.flink.table.connector.source.DynamicFilteringEvent;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.flink.source.DynamicPartitionFilteringInfo;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.PendingSplitsCheckpoint;
import org.apache.paimon.flink.source.ReaderConsumeProgressEvent;
import org.apache.paimon.flink.source.assigners.DynamicPartitionPruningAssigner;
import org.apache.paimon.flink.source.assigners.PreAssignSplitAssigner;
import org.apache.paimon.flink.source.assigners.SplitAssigner;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileStoreSplitEnumerator
implements SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint>,
SupportsHandleExecutionAttemptSourceEvent {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFileStoreSplitEnumerator.class);
    private final SplitEnumeratorContext<FileStoreSourceSplit> context;
    @Nullable
    private final Snapshot snapshot;
    private SplitAssigner splitAssigner;
    @Nullable
    private final DynamicPartitionFilteringInfo dynamicPartitionFilteringInfo;

    public StaticFileStoreSplitEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context, @Nullable Snapshot snapshot, SplitAssigner splitAssigner) {
        this(context, snapshot, splitAssigner, null);
    }

    public StaticFileStoreSplitEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context, @Nullable Snapshot snapshot, SplitAssigner splitAssigner, @Nullable DynamicPartitionFilteringInfo dynamicPartitionFilteringInfo) {
        this.context = context;
        this.snapshot = snapshot;
        this.splitAssigner = splitAssigner;
        this.dynamicPartitionFilteringInfo = dynamicPartitionFilteringInfo;
    }

    public void start() {
    }

    public void handleSplitRequest(int subtask, @Nullable String hostname) {
        if (!this.context.registeredReaders().containsKey(subtask)) {
            return;
        }
        List<FileStoreSourceSplit> assignment = this.splitAssigner.getNext(subtask, hostname);
        if (assignment.size() > 0) {
            this.context.assignSplits(new SplitsAssignment(Collections.singletonMap(subtask, assignment)));
        } else {
            this.context.signalNoMoreSplits(subtask);
        }
    }

    public void addSplitsBack(List<FileStoreSourceSplit> backSplits, int subtaskId) {
        this.splitAssigner.addSplitsBack(subtaskId, backSplits);
    }

    public void addReader(int subtaskId) {
    }

    public PendingSplitsCheckpoint snapshotState(long checkpointId) {
        return new PendingSplitsCheckpoint(this.splitAssigner.remainingSplits(), this.snapshot == null ? null : Long.valueOf(this.snapshot.id()));
    }

    public void close() {
    }

    @Nullable
    public Snapshot snapshot() {
        return this.snapshot;
    }

    public void handleSourceEvent(int subtaskId, int attemptNumber, SourceEvent sourceEvent) {
        this.handleSourceEvent(subtaskId, sourceEvent);
    }

    public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
        if (sourceEvent instanceof ReaderConsumeProgressEvent) {
            return;
        }
        if (sourceEvent.getClass().getSimpleName().equals("DynamicFilteringEvent")) {
            Preconditions.checkNotNull(this.dynamicPartitionFilteringInfo, "Cannot apply dynamic filtering because dynamicPartitionFilteringInfo hasn't been set.");
            this.splitAssigner = this.splitAssigner instanceof PreAssignSplitAssigner ? ((PreAssignSplitAssigner)this.splitAssigner).ofDynamicPartitionPruning(this.dynamicPartitionFilteringInfo.getPartitionRowProjection(), ((DynamicFilteringEvent)sourceEvent).getData()) : DynamicPartitionPruningAssigner.createDynamicPartitionPruningAssignerIfNeeded(subtaskId, this.splitAssigner, this.dynamicPartitionFilteringInfo.getPartitionRowProjection(), sourceEvent, LOG);
        } else {
            LOG.error("Received unrecognized event: {}", (Object)sourceEvent);
        }
    }

    @VisibleForTesting
    public SplitAssigner getSplitAssigner() {
        return this.splitAssigner;
    }
}

