/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.serializer.SerializerSingleton;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.utils.VarLengthIntUtils;

public final class BinaryStringSerializer
extends SerializerSingleton<BinaryString> {
    private static final long serialVersionUID = 1L;
    public static final BinaryStringSerializer INSTANCE = new BinaryStringSerializer();

    private BinaryStringSerializer() {
    }

    @Override
    public BinaryString copy(BinaryString from) {
        return from.copy();
    }

    @Override
    public void serialize(BinaryString string, DataOutputView target) throws IOException {
        VarLengthIntUtils.encodeInt(target, string.getSizeInBytes());
        MemorySegmentUtils.copyToView(string.getSegments(), string.getOffset(), string.getSizeInBytes(), target);
    }

    @Override
    public BinaryString deserialize(DataInputView source2) throws IOException {
        return BinaryStringSerializer.deserializeInternal(source2);
    }

    public static BinaryString deserializeInternal(DataInputView source2) throws IOException {
        int length = VarLengthIntUtils.decodeInt(source2);
        byte[] bytes = new byte[length];
        source2.readFully(bytes);
        return BinaryString.fromBytes(bytes);
    }

    @Override
    public String serializeToString(BinaryString record) {
        return record.toString();
    }

    @Override
    public BinaryString deserializeFromString(String s) {
        return BinaryString.fromString(s);
    }
}

