/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.CloneAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class CloneActionFactory
implements ActionFactory {
    private static final String IDENTIFIER = "clone";
    private static final String TARGET_WAREHOUSE = "target_warehouse";
    private static final String TARGET_DATABASE = "target_database";
    private static final String TARGET_TABLE = "target_table";
    private static final String TARGET_CATALOG_CONF = "target_catalog_conf";
    private static final String PARALLELISM = "parallelism";
    private static final String WHERE = "where";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Map<String, String> catalogConfig = this.catalogConfigMap(params);
        HashMap<String, String> targetCatalogConfig = new HashMap<String, String>(this.optionalConfigMap(params, TARGET_CATALOG_CONF));
        String targetWarehouse = params.get(TARGET_WAREHOUSE);
        if (targetWarehouse != null && !targetCatalogConfig.containsKey("warehouse")) {
            targetCatalogConfig.put("warehouse", targetWarehouse);
        }
        String parallelism = params.get(PARALLELISM);
        CloneAction cloneAction = new CloneAction(params.get("database"), params.get("table"), catalogConfig, params.get(TARGET_DATABASE), params.get(TARGET_TABLE), targetCatalogConfig, parallelism == null ? null : Integer.valueOf(Integer.parseInt(parallelism)), params.get(WHERE));
        return Optional.of(cloneAction);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"clone\" clones the source files and migrate them to paimon table.");
        System.out.println();
    }
}

