/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SideOutputDataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.copy.CopyDataFileOperator;
import org.apache.paimon.flink.copy.CopyFileInfo;
import org.apache.paimon.flink.copy.CopyManifestFileOperator;
import org.apache.paimon.flink.copy.CopyMetaFilesFunction;
import org.apache.paimon.flink.copy.CopySourceBuilder;
import org.apache.paimon.flink.copy.SnapshotHintChannelComputer;
import org.apache.paimon.flink.copy.SnapshotHintOperator;
import org.apache.paimon.flink.sink.FlinkStreamPartitioner;
import org.apache.paimon.utils.StringUtils;

@Deprecated
public class CopyFilesAction
extends ActionBase {
    private final int parallelism;
    private Map<String, String> sourceCatalogConfig;
    private final String database;
    private final String tableName;
    private Map<String, String> targetCatalogConfig;
    private final String targetDatabase;
    private final String targetTableName;

    public CopyFilesAction(String database, String tableName, Map<String, String> sourceCatalogConfig, String targetDatabase, String targetTableName, Map<String, String> targetCatalogConfig, String parallelismStr) {
        super(sourceCatalogConfig);
        this.parallelism = StringUtils.isNullOrWhitespaceOnly(parallelismStr) ? this.env.getParallelism() : Integer.parseInt(parallelismStr);
        this.sourceCatalogConfig = new HashMap<String, String>();
        if (!sourceCatalogConfig.isEmpty()) {
            this.sourceCatalogConfig = sourceCatalogConfig;
        }
        this.database = database;
        this.tableName = tableName;
        this.targetCatalogConfig = new HashMap<String, String>();
        if (!targetCatalogConfig.isEmpty()) {
            this.targetCatalogConfig = targetCatalogConfig;
        }
        this.targetDatabase = targetDatabase;
        this.targetTableName = targetTableName;
    }

    @Override
    public void build() {
        try {
            this.buildCopyFilesFlinkJob(this.env);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void buildCopyFilesFlinkJob(StreamExecutionEnvironment env) throws Exception {
        DataStream<Tuple2<String, String>> source2 = new CopySourceBuilder(env, this.sourceCatalogConfig, this.database, this.tableName, this.targetDatabase, this.targetTableName).build();
        SingleOutputStreamOperator copyMetaFiles = source2.forward().process((ProcessFunction)new CopyMetaFilesFunction(this.sourceCatalogConfig, this.targetCatalogConfig)).name("Side Output").setParallelism(1);
        SideOutputDataStream indexFilesStream = copyMetaFiles.getSideOutput(CopyMetaFilesFunction.INDEX_FILES_TAG);
        SideOutputDataStream dataManifestFilesStream = copyMetaFiles.getSideOutput(CopyMetaFilesFunction.DATA_MANIFEST_FILES_TAG);
        SingleOutputStreamOperator copyIndexFiles = indexFilesStream.transform("Copy Index Files", TypeInformation.of(CopyFileInfo.class), (OneInputStreamOperator)new CopyDataFileOperator(this.sourceCatalogConfig, this.targetCatalogConfig)).setParallelism(this.parallelism);
        SingleOutputStreamOperator copyDataManifestFiles = dataManifestFilesStream.transform("Copy Data Manifest Files", TypeInformation.of(CopyFileInfo.class), (OneInputStreamOperator)new CopyManifestFileOperator(this.sourceCatalogConfig, this.targetCatalogConfig)).setParallelism(this.parallelism);
        SingleOutputStreamOperator copyDataFile = copyDataManifestFiles.transform("Copy Data Files", TypeInformation.of(CopyFileInfo.class), (OneInputStreamOperator)new CopyDataFileOperator(this.sourceCatalogConfig, this.targetCatalogConfig)).setParallelism(this.parallelism);
        DataStream combinedStream = copyDataFile.union(new DataStream[]{copyIndexFiles});
        SingleOutputStreamOperator snapshotHintOperator = FlinkStreamPartitioner.partition(combinedStream, new SnapshotHintChannelComputer(), this.parallelism).transform("Recreate Snapshot Hint", TypeInformation.of(CopyFileInfo.class), (OneInputStreamOperator)new SnapshotHintOperator(this.targetCatalogConfig)).setParallelism(this.parallelism);
        snapshotHintOperator.sinkTo(new DiscardingSink()).name("end").setParallelism(1);
    }

    @Override
    public void run() throws Exception {
        this.build();
        this.execute("Copy Files job");
    }
}

