/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.List;
import java.util.Map;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.flink.sink.listener.PartitionMarkDoneListener;
import org.apache.paimon.partition.actions.PartitionMarkDoneAction;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.PartitionPathUtils;

public class MarkPartitionDoneAction
extends TableActionBase {
    private final FileStoreTable fileStoreTable;
    private final List<Map<String, String>> partitions;

    public MarkPartitionDoneAction(String databaseName, String tableName, List<Map<String, String>> partitions, Map<String, String> catalogConfig) {
        super(databaseName, tableName, catalogConfig);
        if (!(this.table instanceof FileStoreTable)) {
            throw new UnsupportedOperationException(String.format("Only FileStoreTable supports mark_partition_done action. The table type is '%s'.", this.table.getClass().getName()));
        }
        this.fileStoreTable = (FileStoreTable)this.table;
        this.partitions = partitions;
    }

    @Override
    public void run() throws Exception {
        List<PartitionMarkDoneAction> actions = PartitionMarkDoneAction.createActions(this.getClass().getClassLoader(), this.fileStoreTable, this.fileStoreTable.coreOptions());
        List<String> partitionPaths = PartitionPathUtils.generatePartitionPaths(this.partitions, this.fileStoreTable.store().partitionType());
        PartitionMarkDoneListener.markDone(partitionPaths, actions);
        IOUtils.closeAllQuietly(actions);
    }
}

