/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.utils.MultiTablesCompactorUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.EndOfScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiTableScanBase<T>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MultiTableScanBase.class);
    protected final Pattern includingPattern;
    protected final Pattern excludingPattern;
    protected final Pattern databasePattern;
    protected transient Catalog catalog;
    protected boolean isStreaming;
    protected final Map<String, String> tableOptions;

    public MultiTableScanBase(CatalogLoader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, boolean isStreaming, Map<String, String> tableOptions) {
        this.catalog = catalogLoader.load();
        this.includingPattern = includingPattern;
        this.excludingPattern = excludingPattern;
        this.databasePattern = databasePattern;
        this.isStreaming = isStreaming;
        this.tableOptions = tableOptions;
    }

    protected void updateTableMap() throws Catalog.DatabaseNotExistException, Catalog.TableNotExistException {
        List<String> databases = this.catalog.listDatabases();
        for (String databaseName : databases) {
            if (!this.databasePattern.matcher(databaseName).matches()) continue;
            List<String> tables = this.catalog.listTables(databaseName);
            for (String tableName : tables) {
                Identifier identifier = Identifier.create(databaseName, tableName);
                if (!MultiTablesCompactorUtil.shouldCompactTable(identifier, this.includingPattern, this.excludingPattern) || this.checkTableScanned(identifier)) continue;
                Table table = this.catalog.getTable(identifier);
                if (!(table instanceof FileStoreTable)) {
                    LOG.error(String.format("Only FileStoreTable supports compact action. The table type is '%s'.", table.getClass().getName()));
                    continue;
                }
                Table fileStoreTable = ((FileStoreTable)table).copy((Map)this.tableOptions);
                this.addScanTable((FileStoreTable)fileStoreTable, identifier);
            }
        }
    }

    public ScanResult scanTable(ReaderOutput<T> ctx) throws Catalog.TableNotExistException, Catalog.DatabaseNotExistException {
        try {
            this.updateTableMap();
            List<Object> tasks = this.doScan();
            tasks.forEach(arg_0 -> ctx.collect(arg_0));
            return tasks.isEmpty() ? ScanResult.IS_EMPTY : ScanResult.IS_NON_EMPTY;
        }
        catch (EndOfScanException esf) {
            LOG.info("Catching EndOfStreamException, the stream is finished.");
            return ScanResult.FINISHED;
        }
    }

    abstract List<T> doScan();

    abstract boolean checkTableScanned(Identifier var1);

    abstract void addScanTable(FileStoreTable var1, Identifier var2);

    @Override
    public void close() throws Exception {
        if (this.catalog != null) {
            this.catalog.close();
            this.catalog = null;
        }
    }

    public static enum ScanResult {
        FINISHED,
        IS_EMPTY,
        IS_NON_EMPTY;

    }
}

