/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.utils.TableMigrationUtils;
import org.apache.paimon.migrate.Migrator;
import org.apache.paimon.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateIcebergTableProcedure
extends ProcedureBase {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateIcebergTableProcedure.class);
    private static final String PAIMON_SUFFIX = "_paimon_";

    @Override
    public String identifier() {
        return "migrate_iceberg_table";
    }

    @ProcedureHint(argument={@ArgumentHint(name="source_table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="iceberg_options", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="options", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="parallelism", type=@DataTypeHint(value="Integer"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String sourceTablePath, String icebergProperties, String properties, Integer parallelism) throws Exception {
        properties = this.notnull(properties);
        icebergProperties = this.notnull(icebergProperties);
        String targetPaimonTablePath = sourceTablePath + PAIMON_SUFFIX;
        Identifier sourceTableId = Identifier.fromString(sourceTablePath);
        Identifier targetTableId = Identifier.fromString(targetPaimonTablePath);
        Integer p = parallelism == null ? Runtime.getRuntime().availableProcessors() : parallelism.intValue();
        Migrator migrator = TableMigrationUtils.getIcebergImporter(this.catalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), targetTableId.getDatabaseName(), targetTableId.getObjectName(), p, ParameterUtils.parseCommaSeparatedKeyValues(properties), ParameterUtils.parseCommaSeparatedKeyValues(icebergProperties));
        LOG.info("create migrator success.");
        migrator.executeMigrate();
        migrator.renameTable(false);
        return new String[]{"Success"};
    }
}

