/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.types.Row;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;

public class RollbackToTimestampProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "rollback_to_timestamp";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="timestamp", type=@DataTypeHint(value="BIGINT"))})
    @DataTypeHint(value="ROW<previous_snapshot_id BIGINT, current_snapshot_id BIGINT>")
    public Row[] call(ProcedureContext procedureContext, String tableId, Long timestamp) throws Catalog.TableNotExistException {
        Table table = this.catalog.getTable(Identifier.fromString(tableId));
        FileStoreTable fileStoreTable = (FileStoreTable)table;
        SnapshotManager snapshotManager = fileStoreTable.snapshotManager();
        Snapshot latestSnapshot = snapshotManager.latestSnapshot();
        Preconditions.checkNotNull(latestSnapshot, "Latest snapshot is null, can not rollback.");
        Snapshot snapshot = snapshotManager.earlierOrEqualTimeMills(timestamp);
        Preconditions.checkNotNull(snapshot, String.format("count not find snapshot earlier than %s", timestamp));
        long snapshotId = snapshot.id();
        fileStoreTable.rollbackTo(snapshotId);
        return new Row[]{Row.of((Object[])new Object[]{latestSnapshot.id(), snapshotId})};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

