/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.flink.compact.AppendTableCompactor;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.PrepareCommitOperator;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.utils.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppendCompactWorkerOperator<IN>
extends PrepareCommitOperator<IN, Committable> {
    private static final Logger LOG = LoggerFactory.getLogger(AppendCompactWorkerOperator.class);
    private final FileStoreTable table;
    private final String commitUser;
    protected transient AppendTableCompactor unawareBucketCompactor;
    private transient ExecutorService lazyCompactExecutor;

    public AppendCompactWorkerOperator(StreamOperatorParameters<Committable> parameters, FileStoreTable table, String commitUser) {
        super(parameters, Options.fromMap(table.options()));
        this.table = table;
        this.commitUser = commitUser;
    }

    @VisibleForTesting
    Iterable<Future<CommitMessage>> result() {
        return this.unawareBucketCompactor.result();
    }

    public void open() throws Exception {
        LOG.debug("Opened a append-only table compaction worker.");
        this.unawareBucketCompactor = new AppendTableCompactor(this.table, this.commitUser, this::workerExecutor, (MetricGroup)this.getMetricGroup());
    }

    @Override
    protected List<Committable> prepareCommit(boolean waitCompaction, long checkpointId) throws IOException {
        return this.unawareBucketCompactor.prepareCommit(waitCompaction, checkpointId);
    }

    private ExecutorService workerExecutor() {
        if (this.lazyCompactExecutor == null) {
            this.lazyCompactExecutor = Executors.newSingleThreadScheduledExecutor(new ExecutorThreadFactory(Thread.currentThread().getName() + "-append-only-compact-worker"));
        }
        return this.lazyCompactExecutor;
    }

    @Override
    public void close() throws Exception {
        if (this.lazyCompactExecutor != null) {
            this.lazyCompactExecutor.shutdownNow();
            if (!this.lazyCompactExecutor.awaitTermination(120L, TimeUnit.SECONDS)) {
                LOG.warn("Executors shutdown timeout, there may be some files aren't deleted correctly");
            }
            this.unawareBucketCompactor.close();
        }
    }

    protected static abstract class Factory<IN>
    extends PrepareCommitOperator.Factory<IN, Committable> {
        protected final FileStoreTable table;
        protected final String commitUser;

        protected Factory(FileStoreTable table, String commitUser) {
            super(Options.fromMap(table.options()));
            this.table = table;
            this.commitUser = commitUser;
        }
    }
}

