/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcSchema;
import org.apache.paimon.flink.sink.cdc.RichCdcRecord;
import org.apache.paimon.schema.Schema;

public class RichCdcMultiplexRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final String databaseName;
    @Nullable
    private final String tableName;
    private final CdcSchema cdcSchema;
    private final CdcRecord cdcRecord;

    public RichCdcMultiplexRecord(@Nullable String databaseName, @Nullable String tableName, @Nullable CdcSchema cdcSchema, CdcRecord cdcRecord) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.cdcSchema = cdcSchema == null ? CdcSchema.newBuilder().build() : cdcSchema;
        this.cdcRecord = cdcRecord;
    }

    @Nullable
    public String databaseName() {
        return this.databaseName;
    }

    @Nullable
    public String tableName() {
        return this.tableName;
    }

    public CdcSchema cdcSchema() {
        return this.cdcSchema;
    }

    public Schema buildSchema() {
        return new Schema(this.cdcSchema.fields(), Collections.emptyList(), this.cdcSchema.primaryKeys(), Collections.emptyMap(), this.cdcSchema.comment());
    }

    public RichCdcRecord toRichCdcRecord() {
        return new RichCdcRecord(this.cdcRecord, this.cdcSchema);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.tableName, this.cdcSchema, this.cdcRecord);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichCdcMultiplexRecord that = (RichCdcMultiplexRecord)o;
        return Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.cdcSchema, that.cdcSchema) && Objects.equals(this.cdcRecord, that.cdcRecord);
    }

    public String toString() {
        return "{databaseName=" + this.databaseName + ", tableName=" + this.tableName + ", cdcSchema=" + this.cdcSchema + ", cdcRecord=" + this.cdcRecord + '}';
    }
}

