/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.util.Collector;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.sink.cdc.CdcSchema;
import org.apache.paimon.flink.sink.cdc.UpdatedDataFieldsProcessFunctionBase;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.FieldIdentifier;

public class UpdatedDataFieldsProcessFunction
extends UpdatedDataFieldsProcessFunctionBase<CdcSchema, Void> {
    private final SchemaManager schemaManager;
    private final Identifier identifier;
    private Set<FieldIdentifier> latestFields;

    public UpdatedDataFieldsProcessFunction(SchemaManager schemaManager, Identifier identifier, CatalogLoader catalogLoader, TypeMapping typeMapping) {
        super(catalogLoader, typeMapping);
        this.schemaManager = schemaManager;
        this.identifier = identifier;
        this.latestFields = new HashSet<FieldIdentifier>();
    }

    public void processElement(CdcSchema updatedSchema, ProcessFunction.Context context, Collector<Void> collector) throws Exception {
        List<DataField> actualUpdatedDataFields = this.actualUpdatedDataFields(updatedSchema.fields(), this.latestFields);
        if (actualUpdatedDataFields.isEmpty() && updatedSchema.comment() == null) {
            return;
        }
        CdcSchema actualUpdatedSchema = new CdcSchema(actualUpdatedDataFields, updatedSchema.primaryKeys(), updatedSchema.comment());
        for (SchemaChange schemaChange : this.extractSchemaChanges(this.schemaManager, actualUpdatedSchema)) {
            this.applySchemaChange(this.schemaManager, schemaChange, this.identifier, actualUpdatedSchema);
        }
        this.latestFields = this.updateLatestFields(this.schemaManager);
    }
}

