/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.base.source.hybrid.HybridSource;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.Snapshot;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.NestedProjectedRowData;
import org.apache.paimon.flink.log.LogSourceProvider;
import org.apache.paimon.flink.metrics.FlinkMetricRegistry;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FileStoreSourceSplitGenerator;
import org.apache.paimon.flink.source.FlinkSource;
import org.apache.paimon.flink.source.PendingSplitsCheckpoint;
import org.apache.paimon.flink.source.StaticFileStoreSource;
import org.apache.paimon.flink.source.StaticFileStoreSplitEnumerator;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.StreamTableScan;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class LogHybridSourceFactory
implements HybridSource.SourceFactory<RowData, Source<RowData, ?, ?>, StaticFileStoreSplitEnumerator> {
    private final LogSourceProvider provider;

    public LogHybridSourceFactory(LogSourceProvider provider) {
        this.provider = provider;
    }

    public Source<RowData, ?, ?> create(HybridSource.SourceSwitchContext<StaticFileStoreSplitEnumerator> context) {
        Snapshot snapshot;
        StaticFileStoreSplitEnumerator enumerator = (StaticFileStoreSplitEnumerator)context.getPreviousEnumerator();
        Map<Integer, Long> logOffsets = null;
        if (enumerator != null && (snapshot = enumerator.snapshot()) != null) {
            logOffsets = snapshot.logOffsets();
        }
        return this.provider.createSource(logOffsets);
    }

    public static FlinkSource buildHybridFirstSource(Table table, @Nullable RowType readType, @Nullable Predicate predicate, @Nullable NestedProjectedRowData rowData) {
        if (!(table instanceof DataTable)) {
            throw new UnsupportedOperationException(String.format("FlinkHybridFirstSource only accepts DataTable. Unsupported table type: '%s'.", table.getClass().getSimpleName()));
        }
        DataTable dataTable = (DataTable)table;
        ReadBuilder readBuilder = table.newReadBuilder();
        if (readType != null) {
            readBuilder.withReadType(readType);
        }
        return new FlinkHybridFirstSource(readBuilder.withFilter(predicate), dataTable.snapshotManager(), dataTable.coreOptions().toConfiguration(), rowData);
    }

    private static class FlinkHybridFirstSource
    extends FlinkSource {
        private static final long serialVersionUID = 3L;
        private final SnapshotManager snapshotManager;
        private final Options options;

        public FlinkHybridFirstSource(ReadBuilder readBuilder, SnapshotManager snapshotManager, Options options, @Nullable NestedProjectedRowData rowData) {
            super(readBuilder, null, rowData);
            this.snapshotManager = snapshotManager;
            this.options = options;
        }

        public Boundedness getBoundedness() {
            return Boundedness.BOUNDED;
        }

        public SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> restoreEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context, PendingSplitsCheckpoint checkpoint) {
            Collection<FileStoreSourceSplit> splits;
            Long snapshotId = null;
            if (checkpoint == null) {
                FileStoreSourceSplitGenerator splitGenerator = new FileStoreSourceSplitGenerator();
                StreamTableScan scan = this.readBuilder.newStreamScan();
                if (context.metricGroup() != null) {
                    ((StreamDataTableScan)scan).withMetricRegistry(new FlinkMetricRegistry((MetricGroup)context.metricGroup()));
                }
                splits = splitGenerator.createSplits(scan.plan());
                Long nextSnapshotId = scan.checkpoint();
                if (nextSnapshotId != null) {
                    snapshotId = nextSnapshotId - 1L;
                }
            } else {
                snapshotId = checkpoint.currentSnapshotId();
                splits = checkpoint.splits();
            }
            Snapshot snapshot = snapshotId == null ? null : this.snapshotManager.snapshot(snapshotId);
            return new StaticFileStoreSplitEnumerator(context, snapshot, StaticFileStoreSource.createSplitAssigner(context, this.options.get(FlinkConnectorOptions.SCAN_SPLIT_ENUMERATOR_BATCH_SIZE), this.options.get(FlinkConnectorOptions.SCAN_SPLIT_ENUMERATOR_ASSIGN_MODE), splits));
        }
    }
}

